/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.utils;

import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.TypeInfoCollectionWrapper;
import org.geoserver.wms.featureinfo.FeatureCollectionDecorator;
import org.geotools.api.feature.type.Name;
import org.geotools.feature.FeatureCollection;

public class FeatureTypeInfoUtils {
    public static FeatureTypeInfo getFeatureTypeInfo(Catalog catalog, FeatureCollection collection) {
        if (collection instanceof TypeInfoCollectionWrapper) {
            return ((TypeInfoCollectionWrapper)collection).getFeatureTypeInfo();
        }
        if (collection instanceof FeatureCollectionDecorator) {
            return FeatureTypeInfoUtils.getFeatureTypeInfo(catalog, ((FeatureCollectionDecorator)collection).getName());
        }
        return FeatureTypeInfoUtils.getFeatureTypeInfo(catalog, collection.getSchema().getName());
    }

    public static FeatureTypeInfo getFeatureTypeInfo(Catalog catalog, String collectionId) {
        FeatureTypeInfo featureType = catalog.getFeatureTypeByName(collectionId);
        if (featureType == null) {
            throw new ServiceException("Unknown collection " + collectionId, "InvalidParameterValue", "collectionId");
        }
        return featureType;
    }

    public static FeatureTypeInfo getFeatureTypeInfo(Catalog catalog, Name name) {
        return catalog.getFeatureTypeByName(name);
    }
}

