/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.geoserver.featurestemplating.writers.GMLDialectManager;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;

class GML2DialectManager
extends GMLDialectManager {
    GML2DialectManager(XMLStreamWriter streamWriter) {
        super(streamWriter, "coordinates");
    }

    @Override
    void writeNumberReturned(String numberReturned) throws XMLStreamException {
        this.streamWriter.writeAttribute("numberOfFeature", numberReturned);
    }

    @Override
    void writeNumberMatched(String numberMatched) throws XMLStreamException {
    }

    @Override
    void writeBoundingBox(ReferencedEnvelope envelope, CoordinateReferenceSystem crs) throws IOException {
        super.writeBoundingBox(envelope, crs, false);
    }

    @Override
    void writeMultiPolygon(MultiPolygon multiPolygon, String gmlNsUri) throws XMLStreamException {
        int numGeom = multiPolygon.getNumGeometries();
        this.streamWriter.writeStartElement("gml", "MultiPolygon", gmlNsUri);
        for (int i = 0; i < numGeom; ++i) {
            this.streamWriter.writeStartElement("gml", "polygonMember", gmlNsUri);
            this.writePolygon((Polygon)multiPolygon.getGeometryN(i), gmlNsUri);
            this.streamWriter.writeEndElement();
        }
        this.streamWriter.writeEndElement();
    }

    @Override
    void writePolygon(Polygon polygon, String gmlNsUri) throws XMLStreamException {
        LinearRing exteriorRing = polygon.getExteriorRing();
        Coordinate[] coordinates = exteriorRing.getCoordinates();
        this.streamWriter.writeStartElement("gml", "Polygon", gmlNsUri);
        this.writePolygonRing("outerBoundaryIs", coordinates, gmlNsUri);
        int numInterior = polygon.getNumInteriorRing();
        for (int i = 0; i < numInterior; ++i) {
            coordinates = polygon.getInteriorRingN(i).getCoordinates();
            this.writePolygonRing("innerBoundaryIs", coordinates, gmlNsUri);
        }
        this.streamWriter.writeEndElement();
    }

    @Override
    String getWfsNsUri() {
        return "http://www.opengis.net/wfs";
    }

    @Override
    String getGmlNsUri() {
        return "http://www.opengis.net/gml";
    }

    @Override
    void startFeatureMember() throws XMLStreamException {
        this.streamWriter.writeStartElement("gml", "featureMember", this.getGmlNsUri());
    }
}

