/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.math.BigInteger;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.writers.CommonJSONWriter;
import org.geotools.filter.function.FilterFunction_toWKT;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class JSONLDWriter
extends CommonJSONWriter {
    private boolean encodeAsString;

    public JSONLDWriter(JsonGenerator generator) {
        super(generator, TemplateIdentifier.JSONLD);
    }

    @Override
    public void writeValue(Object value) throws IOException {
        if (!this.encodeAsString) {
            super.writeValue(value);
        } else {
            this.generator.writeString(String.valueOf(value));
        }
    }

    @Override
    public void writeGeometry(Object value) throws IOException {
        if (!this.encodeAsString) {
            super.writeGeometry(value);
        } else {
            FilterFunction_toWKT toWKT = new FilterFunction_toWKT();
            String wkt = (String)toWKT.evaluate(value);
            this.generator.writeString(wkt);
        }
    }

    @Override
    public void startTemplateOutput(EncodingHints encodingHints) throws IOException {
        this.writeStartObject();
        String contextName = "@context";
        JsonNode context = this.getEncodingHintIfPresent(encodingHints, "@context", JsonNode.class);
        if (context != null) {
            if (context.isArray()) {
                this.writeArrayNode(contextName, context);
            } else if (context.isObject()) {
                this.writeObjectNode(contextName, context);
            } else {
                this.writeValueNode(contextName, context);
            }
        }
        if (!EncodingHints.isSingleFeatureRequest()) {
            this.generator.writeFieldName("type");
            this.generator.writeString("FeatureCollection");
            String jsonLdType = encodingHints.get("@type", String.class, "FeatureCollection");
            this.generator.writeFieldName("@type");
            this.generator.writeString(jsonLdType);
            String collectionName = encodingHints.get("collection_name", String.class, "features");
            this.generator.writeFieldName(collectionName);
            this.writeStartArray();
        }
    }

    @Override
    public void writeCollectionCounts(BigInteger featureCount) throws IOException {
    }

    @Override
    public void writeCrs() throws IOException {
    }

    @Override
    public void writeCollectionBounds(ReferencedEnvelope bounds) throws IOException {
    }

    @Override
    public void writeTimeStamp() throws IOException {
    }

    @Override
    public void writeNumberReturned() throws IOException {
    }

    @Override
    public void startObject(String name, EncodingHints encodingHints) throws IOException {
        if (!this.skipObjectWriting(encodingHints)) {
            super.startObject(name, encodingHints);
        }
    }

    @Override
    public void endObject(String name, EncodingHints encodingHints) throws IOException {
        if (!this.skipObjectWriting(encodingHints)) {
            super.endObject(name, encodingHints);
        }
    }

    public void setEncodeAsString(boolean encodeAsString) {
        this.encodeAsString = encodeAsString;
    }
}

