/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilderMaker;
import org.geoserver.featurestemplating.builders.impl.DynamicMergeBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.readers.JSONMerger;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.featurestemplating.writers.GeoJSONWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.feature.Feature;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataTestCase;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class DynamicMergeBuilderTest
extends DataTestCase {
    private static final String BASE = "{\"metadata\":{\"metadata_iso_19139\":{\"title\":\"basetext\",\"href\":\"basehref\",\"type\":\"basetype\"}}}";
    private static final String DYNAMIC_METADATA = "{\"metadata\":{\"metadata_iso_19139\":{\"title\":\"metadata_iso_19139\",\"dynamicValue\":\"${dynamicValue}\",\"href\":\"http://metadata_iso_19139.org\",\"type\":\"metadata\"}}}";
    private static final String STATIC_METADATA = "{\"metadata\":{\"metadata_iso_19139\":{\"title\":\"metadata_iso_19139\",\"href\":\"http://metadata_iso_19139.org\",\"type\":\"metadata\"}}}";
    private JsonNode node;
    private SimpleFeature jsonFieldSimpleFeature;

    @Before
    public void setup() throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        this.node = mapper.readTree(BASE);
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.userData((Object)"org.geotools.jdbc.nativeTypeName", (Object)"json");
        tb.add("dynamicMetadata", String.class);
        tb.add("staticMetadata", String.class);
        tb.add("dynamicValue", String.class);
        tb.add("arrayMetadata", String.class);
        tb.setName("jsonFieldSimpleType");
        SimpleFeatureType schema = tb.buildFeatureType();
        schema.getDescriptor("dynamicMetadata").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        schema.getDescriptor("staticMetadata").getUserData().put("org.geotools.jdbc.nativeTypeName", "json");
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        fb.add((Object)DYNAMIC_METADATA);
        fb.add((Object)STATIC_METADATA);
        fb.add((Object)"dynamic value result");
        this.jsonFieldSimpleFeature = fb.buildFeature("jsonFieldSimpleType.1");
    }

    @Test
    public void testObtainDynamicMergeBuilder() throws JsonProcessingException {
        JsonNode overlay = new ObjectMapper().readTree("{\"metadata\":\"${staticMetadata}\"}");
        ObjectNode mergedNode = new JSONMerger().mergeTrees(this.node, overlay);
        TemplateBuilderMaker builderMaker = new TemplateBuilderMaker();
        TemplateBuilder build = builderMaker.build();
        TemplateReaderConfiguration configuration = new TemplateReaderConfiguration(null);
        new JSONTemplateReader((JsonNode)mergedNode, configuration, new ArrayList()).getBuilderFromJson(null, (JsonNode)mergedNode, build, builderMaker);
        Assert.assertTrue((boolean)(build.getChildren().get(0) instanceof DynamicMergeBuilder));
    }

    @Test
    public void testMergeStaticResultOverlayExpression() throws Exception {
        JSONObject json = this.encodeDynamicMerge("${staticMetadata}", (Feature)this.jsonFieldSimpleFeature, true);
        JSONObject metadata19139 = json.getJSONObject("dynamicMergeBuilder").getJSONObject("metadata").getJSONObject("metadata_iso_19139");
        Assert.assertEquals((Object)"metadata_iso_19139", (Object)metadata19139.getString("title"));
        Assert.assertEquals((Object)"http://metadata_iso_19139.org", (Object)metadata19139.getString("href"));
        Assert.assertEquals((Object)"metadata", (Object)metadata19139.getString("type"));
    }

    @Test
    public void testMergeStaticResultBaseExpression() throws Exception {
        JSONObject json = this.encodeDynamicMerge("${staticMetadata}", (Feature)this.jsonFieldSimpleFeature, false);
        JSONObject metadata19139 = json.getJSONObject("dynamicMergeBuilder").getJSONObject("metadata").getJSONObject("metadata_iso_19139");
        Assert.assertEquals((Object)"basetext", (Object)metadata19139.getString("title"));
        Assert.assertEquals((Object)"basehref", (Object)metadata19139.getString("href"));
        Assert.assertEquals((Object)"basetype", (Object)metadata19139.getString("type"));
    }

    @Test
    public void testErrorWhenJsonAttributeWithDirectives() throws IOException {
        String message = null;
        try {
            this.encodeDynamicMerge("${dynamicMetadata}", (Feature)this.jsonFieldSimpleFeature, false);
        }
        catch (UnsupportedOperationException e) {
            message = e.getMessage();
        }
        Assert.assertEquals((Object)message, (Object)"A json attribute value cannot have a template directive among its fields.");
    }

    private JSONObject encodeDynamicMerge(String expression, Feature feature, boolean overlayExpression) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GeoJSONWriter writer = new GeoJSONWriter(new JsonFactory().createGenerator((OutputStream)baos, JsonEncoding.UTF8), TemplateIdentifier.JSON);
        DynamicMergeBuilder builder = new DynamicMergeBuilder("dynamicMergeBuilder", expression, new NamespaceSupport(), this.node, overlayExpression);
        writer.writeStartObject();
        builder.evaluate((TemplateOutputWriter)writer, new TemplateBuilderContext((Object)feature));
        writer.writeEndObject();
        writer.close();
        String jsonString = new String(baos.toByteArray());
        return (JSONObject)JSONSerializer.toJSON((Object)jsonString);
    }
}

