/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions;

import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geotools.api.filter.FilterFactory;
import org.geotools.api.filter.expression.Expression;
import org.geotools.factory.CommonFactoryFinder;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;

public class RequestFunctionsTest {
    static final FilterFactory FF = CommonFactoryFinder.getFilterFactory();

    @BeforeClass
    public static void setDispatcherRequest() {
        MockHttpServletRequest req = new MockHttpServletRequest();
        req.setScheme("http");
        req.setServerPort(8080);
        req.setContextPath("/geoserver");
        req.setPathInfo("/wfs");
        req.addParameter("testParameter", "testParameterValue");
        req.addHeader("testHeader", (Object)"testHeaderValue");
        Request request = new Request();
        request.setOutputFormat("application/json");
        request.setHttpRequest((HttpServletRequest)req);
        Dispatcher.REQUEST.set(request);
    }

    @Test
    public void testRequestParamFunction() {
        String result = (String)FF.function("requestParam", new Expression[]{FF.literal((Object)"testParameter")}).evaluate(Dispatcher.REQUEST.get());
        Assert.assertEquals((Object)"testParameterValue", (Object)result);
    }

    @Test
    public void testRequestHeaderFunction() {
        String result = (String)FF.function("header", new Expression[]{FF.literal((Object)"testHeader")}).evaluate(Dispatcher.REQUEST.get());
        Assert.assertEquals((Object)"testHeaderValue", (Object)result);
    }

    @Test
    public void testMimeTypeFunction() {
        String result = (String)FF.function("mimeType", new Expression[0]).evaluate(Dispatcher.REQUEST.get());
        Assert.assertEquals((Object)"application/json", (Object)result);
    }

    @Test
    public void testRequestRegexMatch() {
        Boolean result = (Boolean)FF.function("requestMatchRegex", new Expression[]{FF.literal((Object)"^.*wfs.*$")}).evaluate(Dispatcher.REQUEST.get());
        Assert.assertTrue((boolean)result);
        result = (Boolean)FF.function("requestMatchRegex", new Expression[]{FF.literal((Object)"^.*wms.*$")}).evaluate(Dispatcher.REQUEST.get());
        Assert.assertFalse((boolean)result);
    }
}

