/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.File;
import java.io.IOException;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.data.test.MockData;
import org.geoserver.platform.resource.Resource;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.springframework.mock.web.MockHttpServletResponse;

public abstract class TemplateJSONSimpleTestSupport
extends GeoServerSystemTestSupport {
    Catalog catalog;
    FeatureTypeInfo typeInfo;
    GeoServerDataDirectory dd;

    @Before
    public void before() {
        this.catalog = this.getCatalog();
        this.typeInfo = this.catalog.getFeatureTypeByName(MockData.CITE_PREFIX, MockData.NAMED_PLACES.getLocalPart());
        this.dd = (GeoServerDataDirectory)applicationContext.getBean("dataDirectory");
    }

    protected void setUpSimple(String fileName) throws IOException {
        File file = this.dd.getResourceLoader().createFile(new String[]{"workspaces/cite/" + this.typeInfo.getStore().getName() + "/" + this.typeInfo.getName(), this.getTemplateFileName()});
        this.dd.getResourceLoader().copyFromClassPath(fileName, file, ((Object)((Object)this)).getClass());
    }

    @After
    public void cleanup() {
        Resource res = this.dd.getResourceLoader().get("workspaces/cite/" + this.typeInfo.getStore().getName() + "/" + this.typeInfo.getName() + "/" + this.getTemplateFileName());
        if (res != null) {
            res.delete();
        }
    }

    protected abstract String getTemplateFileName();

    protected JSON getJsonLd(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        Assert.assertEquals((Object)response.getContentType(), (Object)"application/ld+json");
        return this.json(response);
    }

    protected JSON getJson(String path) throws Exception {
        MockHttpServletResponse response = this.getAsServletResponse(path);
        String contentType = response.getContentType();
        if (contentType != null) {
            Assert.assertEquals((Object)contentType, (Object)"application/json");
        }
        return this.json(response);
    }

    protected void checkAdditionalInfo(JSONObject result) {
        Assert.assertNotNull((Object)result.get("numberReturned"));
        Assert.assertNotNull((Object)result.get("timeStamp"));
        if (result.has("crs")) {
            JSONObject crs = result.getJSONObject("crs");
            JSONObject props = crs.getJSONObject("properties");
            Assert.assertNotNull((Object)props);
            Assert.assertNotNull((Object)props.getString("name"));
        }
        if (result.has("links")) {
            JSONArray links = result.getJSONArray("links");
            Assert.assertTrue((links.size() > 0 ? 1 : 0) != 0);
        }
    }
}

