/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders;

import com.fasterxml.jackson.databind.JsonNode;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.VendorOptions;
import org.geoserver.featurestemplating.builders.flat.FlatCompositeBuilder;
import org.geoserver.featurestemplating.builders.flat.FlatDynamicBuilder;
import org.geoserver.featurestemplating.builders.flat.FlatIteratingBuilder;
import org.geoserver.featurestemplating.builders.flat.FlatStaticBuilder;
import org.geoserver.featurestemplating.builders.impl.ArrayIncludeFlatBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicIncludeFlatBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicMergeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.IteratingBuilder;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.xml.sax.helpers.NamespaceSupport;

public class TemplateBuilderMaker {
    private boolean rootBuilder;
    private String rootCollectionName;
    private JsonNode jsonNode;
    private String textContent;
    private String name;
    private String filter;
    private String source;
    private boolean isCollection;
    private boolean flatOutput;
    private boolean ownOutput = true;
    private boolean topLevelFeature;
    private boolean dynamicIncludeFlatBuilder = false;
    private EncodingHints encondingHints = new EncodingHints();
    private VendorOptions vendorOptions = new VendorOptions();
    private NamespaceSupport namespaces;
    private String separator = "_";
    private JsonNode baseNode;
    private JsonNode overlayNode;

    public TemplateBuilderMaker() {
    }

    public TemplateBuilderMaker(String rootCollectionName) {
        this();
        this.rootCollectionName = rootCollectionName;
    }

    public TemplateBuilderMaker textContent(String textContent) {
        this.textContent = textContent.trim();
        return this;
    }

    public TemplateBuilderMaker jsonNode(JsonNode jsonNode) {
        this.jsonNode = jsonNode;
        return this;
    }

    public TemplateBuilderMaker baseNode(JsonNode baseMergeNode) {
        this.baseNode = baseMergeNode;
        return this;
    }

    public TemplateBuilderMaker overlayNode(JsonNode overlayMergeNode) {
        this.overlayNode = overlayMergeNode;
        return this;
    }

    public TemplateBuilderMaker content(Object content) {
        if (content instanceof String) {
            this.textContent(content.toString());
        } else if (content instanceof JsonNode) {
            this.jsonNode((JsonNode)content);
        } else {
            throw new UnsupportedOperationException("Unsupported content for builders. Content is of type " + content.getClass());
        }
        return this;
    }

    public TemplateBuilderMaker name(String name) {
        this.name = name;
        return this;
    }

    public TemplateBuilderMaker filter(String filter) {
        this.filter = filter;
        return this;
    }

    public TemplateBuilderMaker contentAndFilter(String contentAndFilter) {
        String filter = null;
        String content = null;
        if (contentAndFilter.contains("$filter")) {
            contentAndFilter = contentAndFilter.replace("$filter{", "");
            int sepIndex = contentAndFilter.indexOf(125) + 1;
            String sep = String.valueOf(contentAndFilter.charAt(sepIndex));
            String[] arrData = contentAndFilter.split(sep);
            content = arrData[1];
            filter = arrData[0];
            filter = filter.substring(0, filter.length() - 1);
            this.filter(filter).textContent(content);
        } else {
            this.textContent(contentAndFilter);
        }
        return this;
    }

    public TemplateBuilderMaker source(String source) {
        this.source = source;
        return this;
    }

    public TemplateBuilderMaker collection(boolean collection) {
        this.isCollection = collection;
        return this;
    }

    public TemplateBuilderMaker flatOutput(boolean flatOutput) {
        this.flatOutput = flatOutput;
        return this;
    }

    public TemplateBuilderMaker hasOwnOutput(boolean hasOwnOutput) {
        this.ownOutput = hasOwnOutput;
        return this;
    }

    public TemplateBuilderMaker encodingOption(String name, Object value) {
        this.encondingHints.put(name, value);
        return this;
    }

    public TemplateBuilderMaker namespaces(NamespaceSupport namespaceSupport) {
        this.namespaces = namespaceSupport;
        return this;
    }

    public TemplateBuilderMaker separator(String separator) {
        if (separator != null) {
            this.separator = separator;
        }
        return this;
    }

    public TemplateBuilderMaker rootBuilder(boolean rootBuilder) {
        this.rootBuilder = rootBuilder;
        return this;
    }

    public TemplateBuilderMaker topLevelFeature(boolean topLevelFeature) {
        this.topLevelFeature = topLevelFeature;
        return this;
    }

    public TemplateBuilderMaker dynamicIncludeFlatBuilder(boolean dynamicIncludeFlatBuilder) {
        this.dynamicIncludeFlatBuilder = dynamicIncludeFlatBuilder;
        return this;
    }

    public void globalReset() {
        this.localReset();
        this.namespaces = null;
        this.separator = null;
        this.flatOutput = false;
    }

    public void localReset() {
        this.encondingHints = new EncodingHints();
        this.vendorOptions = new VendorOptions();
        this.filter = null;
        this.isCollection = false;
        this.ownOutput = true;
        this.name = null;
        this.source = null;
        this.textContent = null;
        this.jsonNode = null;
        this.rootBuilder = false;
        this.topLevelFeature = false;
        this.dynamicIncludeFlatBuilder = false;
        this.baseNode = null;
        this.overlayNode = null;
    }

    public RootBuilder buildRootBuilder() {
        RootBuilder rootBuilder = new RootBuilder();
        if (!this.encondingHints.isEmpty()) {
            rootBuilder.getEncodingHints().putAll(this.encondingHints);
        }
        if (!this.vendorOptions.isEmpty()) {
            rootBuilder.addVendorOptions(this.vendorOptions);
        }
        this.localReset();
        return rootBuilder;
    }

    private IteratingBuilder buildIteratingBuilder() {
        IteratingBuilder iteratingBuilder = this.flatOutput ? new FlatIteratingBuilder(this.name, this.namespaces, this.separator, this.topLevelFeature) : new IteratingBuilder(this.name, this.namespaces, this.topLevelFeature);
        if (this.source != null) {
            iteratingBuilder.setSource(this.source);
        }
        if (this.filter != null) {
            iteratingBuilder.setFilter(this.filter);
        }
        if (!this.encondingHints.isEmpty()) {
            iteratingBuilder.getEncodingHints().putAll(this.encondingHints);
        }
        if (this.name != null && this.rootCollectionName != null && this.rootCollectionName.equals(this.name)) {
            this.ownOutput = false;
        }
        iteratingBuilder.setOwnOutput(this.ownOutput);
        iteratingBuilder.setTopLevelFeature(this.topLevelFeature);
        return iteratingBuilder;
    }

    private CompositeBuilder buildCompositeBuilder() {
        CompositeBuilder compositeBuilder = this.flatOutput ? new FlatCompositeBuilder(this.name, this.namespaces, this.separator, this.topLevelFeature) : new CompositeBuilder(this.name, this.namespaces, this.topLevelFeature);
        if (this.source != null) {
            compositeBuilder.setSource(this.source);
        }
        if (this.filter != null) {
            compositeBuilder.setFilter(this.filter);
        }
        if (!this.encondingHints.isEmpty()) {
            compositeBuilder.getEncodingHints().putAll(this.encondingHints);
        }
        compositeBuilder.setOwnOutput(this.ownOutput);
        return compositeBuilder;
    }

    private DynamicValueBuilder buildDynamicBuilder() {
        DynamicValueBuilder dynamicValueBuilder = this.flatOutput ? new FlatDynamicBuilder(this.name, this.textContent, this.namespaces, this.separator) : new DynamicValueBuilder(this.name, this.textContent, this.namespaces);
        if (this.filter != null) {
            dynamicValueBuilder.setFilter(this.filter);
        }
        if (!this.encondingHints.isEmpty()) {
            dynamicValueBuilder.getEncodingHints().putAll(this.encondingHints);
        }
        return dynamicValueBuilder;
    }

    private DynamicMergeBuilder buildDynamicMergeBuilder() {
        JsonNode node;
        String expression;
        boolean overlayExpression = true;
        if (this.baseNode.isTextual()) {
            expression = this.baseNode.textValue();
            overlayExpression = false;
            node = this.overlayNode;
        } else {
            expression = this.overlayNode.textValue();
            node = this.baseNode;
        }
        DynamicMergeBuilder dynamicMergeBuilder = new DynamicMergeBuilder(this.name, expression, this.namespaces, node, overlayExpression);
        if (this.filter != null) {
            dynamicMergeBuilder.setFilter(this.filter);
        }
        if (!this.encondingHints.isEmpty()) {
            dynamicMergeBuilder.getEncodingHints().putAll(this.encondingHints);
        }
        return dynamicMergeBuilder;
    }

    private DynamicIncludeFlatBuilder buildDynamicIncludeFlatBuilder() {
        DynamicIncludeFlatBuilder dynamicIncludeFlatBuilder = new DynamicIncludeFlatBuilder(this.textContent, this.namespaces, this.baseNode);
        if (this.filter != null) {
            dynamicIncludeFlatBuilder.setFilter(this.filter);
        }
        if (!this.encondingHints.isEmpty()) {
            dynamicIncludeFlatBuilder.getEncodingHints().putAll(this.encondingHints);
        }
        return dynamicIncludeFlatBuilder;
    }

    private ArrayIncludeFlatBuilder buildArrayIncludeFlatBuilder() {
        ArrayIncludeFlatBuilder arrayIncludeFlatBuilder = new ArrayIncludeFlatBuilder(this.name, this.textContent, this.namespaces, this.baseNode);
        if (this.filter != null) {
            arrayIncludeFlatBuilder.setFilter(this.filter);
        }
        if (!this.encondingHints.isEmpty()) {
            arrayIncludeFlatBuilder.getEncodingHints().putAll(this.encondingHints);
        }
        return arrayIncludeFlatBuilder;
    }

    private StaticBuilder buildStaticBuilder() {
        boolean hasFilter;
        boolean hasJsonNode = this.jsonNode != null;
        boolean bl = hasFilter = this.filter != null;
        StaticBuilder staticBuilder = this.flatOutput ? (hasJsonNode && !hasFilter ? new FlatStaticBuilder(this.name, this.jsonNode, this.namespaces, this.separator) : new FlatStaticBuilder(this.name, this.textContent, this.namespaces, this.separator)) : (hasJsonNode && !hasFilter ? new StaticBuilder(this.name, this.jsonNode, this.namespaces) : new StaticBuilder(this.name, this.textContent, this.namespaces));
        if (this.filter != null) {
            staticBuilder.setFilter(this.filter);
        }
        if (!this.encondingHints.isEmpty()) {
            staticBuilder.getEncodingHints().putAll(this.encondingHints);
        }
        return staticBuilder;
    }

    public TemplateBuilder build() {
        TemplateBuilder result = this.rootBuilder ? this.buildRootBuilder() : (this.baseNode != null && this.overlayNode != null ? this.buildDynamicMergeBuilder() : (this.dynamicIncludeFlatBuilder ? (this.isCollection ? this.buildArrayIncludeFlatBuilder() : this.buildDynamicIncludeFlatBuilder()) : (this.textContent == null && this.jsonNode == null ? (this.isCollection ? this.buildIteratingBuilder() : this.buildCompositeBuilder()) : (this.textContent != null && this.textContent.contains("${") ? this.buildDynamicBuilder() : this.buildStaticBuilder()))));
        this.localReset();
        return result;
    }
}

