/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.flat;

import java.io.IOException;
import java.util.List;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.flat.AttributeNameHelper;
import org.geoserver.featurestemplating.builders.flat.FlatBuilder;
import org.geoserver.featurestemplating.builders.flat.FlatCompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.IteratingBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.util.Converters;
import org.xml.sax.helpers.NamespaceSupport;

public class FlatIteratingBuilder
extends IteratingBuilder
implements FlatBuilder {
    private AttributeNameHelper nameHelper;

    public FlatIteratingBuilder(String key, NamespaceSupport namespaces, String separator) {
        super(key, namespaces);
        this.nameHelper = new AttributeNameHelper(this.key, separator);
    }

    public FlatIteratingBuilder(String key, NamespaceSupport namespaces, String separator, boolean topLevelComplex) {
        super(key, namespaces, topLevelComplex);
        this.nameHelper = new AttributeNameHelper(this.key, separator);
    }

    public FlatIteratingBuilder(FlatIteratingBuilder builder, boolean includeChildren) {
        super(builder, includeChildren);
        this.nameHelper = new AttributeNameHelper(this.key, builder.nameHelper.getSeparator());
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        if (this.ownOutput) {
            Object o = (context = this.evaluateSource(context)).getCurrentObj();
            if (o != null) {
                if (o instanceof List) {
                    this.evaluateCollection(writer, (List)o, context.getParent(), false);
                } else if (o.getClass().isArray()) {
                    List list = (List)Converters.convert((Object)o, List.class);
                    this.evaluateCollection(writer, list, context.getParent(), false);
                } else {
                    this.evaluateInternal(writer, context, 0, 1);
                }
            }
        } else if (this.evaluateFilter(context)) {
            this.addSkipObjectEncodingHint(context);
            for (TemplateBuilder child : this.children) {
                AbstractTemplateBuilder abstractChild = (AbstractTemplateBuilder)child;
                if (child instanceof FlatCompositeBuilder) {
                    writer.startObject(abstractChild.getKey(context), this.encodingHints);
                }
                child.evaluate(writer, context);
                if (!(child instanceof FlatCompositeBuilder)) continue;
                writer.endObject(abstractChild.getKey(context), this.encodingHints);
            }
        }
    }

    @Override
    public void evaluateCollection(TemplateOutputWriter writer, List elements, TemplateBuilderContext parent, boolean iterateKey) throws IOException {
        int elementsSize = elements.size();
        int actualIndex = 1;
        for (int i = 0; i < elementsSize; ++i) {
            Object o = elements.get(i);
            TemplateBuilderContext childContext = new TemplateBuilderContext(o);
            childContext.setParent(parent);
            if (!this.evaluateFilter(childContext)) continue;
            this.evaluateInternal(writer, childContext, elementsSize, actualIndex);
            ++actualIndex;
        }
    }

    protected void evaluateInternal(TemplateOutputWriter writer, TemplateBuilderContext context, int elementsSize, int index) throws IOException {
        for (TemplateBuilder child : this.children) {
            ((FlatBuilder)((Object)child)).setParentKey(this.nameHelper.getCompleteIteratingAttributeName(elementsSize, index));
            child.evaluate(writer, context);
        }
    }

    @Override
    public void setParentKey(String parentKey) {
        this.nameHelper.setParentKey(parentKey);
    }

    @Override
    public FlatIteratingBuilder copy(boolean includeChildren) {
        return new FlatIteratingBuilder(this, includeChildren);
    }
}

