/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.builders.visitors.TemplateVisitor;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.util.Converters;
import org.xml.sax.helpers.NamespaceSupport;

public class IteratingBuilder
extends SourceBuilder {
    public IteratingBuilder(String key, NamespaceSupport namespaces) {
        super(key, namespaces, false);
    }

    public IteratingBuilder(String key, NamespaceSupport namespaces, boolean topLevelComplex) {
        super(key, namespaces, topLevelComplex);
    }

    public IteratingBuilder(IteratingBuilder iteratingBuilder, boolean includeChildren) {
        super(iteratingBuilder, includeChildren);
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        if (this.ownOutput) {
            if ((context = this.evaluateSource(context)).getCurrentObj() != null) {
                this.evaluateNonFeaturesField(writer, context);
            }
        } else {
            this.evaluateInternal(writer, context, false);
        }
    }

    protected void evaluateNonFeaturesField(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        if (this.canWrite(context)) {
            boolean isArray;
            boolean iterateKey = this.isIterateKey();
            String key = this.getKey(context);
            Object o = context.getCurrentObj();
            boolean isList = o instanceof List;
            boolean bl = isArray = o != null && o.getClass().isArray();
            if (!iterateKey && this.hasOwnOutput()) {
                writer.startArray(key, this.encodingHints);
            }
            if (isList) {
                this.evaluateCollection(writer, (List)context.getCurrentObj(), context.getParent(), iterateKey);
            } else if (isArray) {
                List list = (List)Converters.convert((Object)o, List.class);
                this.evaluateCollection(writer, list, context.getParent(), iterateKey);
            } else {
                this.evaluateInternal(writer, context, iterateKey);
            }
            if (!iterateKey && this.hasOwnOutput()) {
                writer.endArray(key, this.encodingHints);
            }
        }
    }

    protected void evaluateCollection(TemplateOutputWriter writer, List elements, TemplateBuilderContext parent, boolean iterateKey) throws IOException {
        for (Object o : elements) {
            TemplateBuilderContext childContext = new TemplateBuilderContext(o);
            childContext.setParent(parent);
            if (!this.evaluateFilter(childContext)) continue;
            String key = this.getKey(parent);
            if (iterateKey && this.hasOwnOutput()) {
                writer.startArray(key, this.encodingHints);
            }
            for (TemplateBuilder child : this.children) {
                child.evaluate(writer, childContext);
            }
            if (!iterateKey || !this.hasOwnOutput()) continue;
            writer.endArray(key, this.encodingHints);
        }
    }

    protected void evaluateInternal(TemplateOutputWriter writer, TemplateBuilderContext context, boolean iterateKey) throws IOException {
        if (this.evaluateFilter(context)) {
            String key = this.getKey(context);
            if (iterateKey && this.hasOwnOutput()) {
                writer.startArray(key, this.encodingHints);
            }
            for (TemplateBuilder child : this.children) {
                child.evaluate(writer, context);
            }
            if (iterateKey && this.hasOwnOutput()) {
                writer.endArray(key, this.encodingHints);
            }
        }
    }

    @Override
    public boolean canWrite(TemplateBuilderContext context) {
        Object o = context.getCurrentObj();
        boolean result = o instanceof List ? this.canWriteList((List)o, context) : (o != null && o.getClass().isArray() ? this.canWriteArray(o, context) : this.canWriteSingle(o, context));
        return result;
    }

    private boolean canWriteList(List elements, TemplateBuilderContext context) {
        for (Object el : elements) {
            TemplateBuilderContext childContext = new TemplateBuilderContext(el);
            childContext.setParent(context.getParent());
            if (!this.evaluateFilter(childContext)) continue;
            return true;
        }
        return false;
    }

    private boolean canWriteArray(Object array, TemplateBuilderContext context) {
        int length = Array.getLength(array);
        for (int i = 0; i < length; ++i) {
            Object item = Array.get(array, i);
            TemplateBuilderContext childContext = new TemplateBuilderContext(item);
            childContext.setParent(context.getParent());
            if (!this.evaluateFilter(childContext)) continue;
            return true;
        }
        return false;
    }

    private boolean canWriteSingle(Object element, TemplateBuilderContext context) {
        TemplateBuilderContext childContext = new TemplateBuilderContext(element);
        childContext.setParent(context.getParent());
        return this.evaluateFilter(childContext);
    }

    private boolean isIterateKey() {
        Object iterateKey = this.getEncodingHints().get("INTERATE_KEY");
        return iterateKey != null && Boolean.valueOf(iterateKey.toString()) != false;
    }

    @Override
    public Object accept(TemplateVisitor visitor, Object value) {
        return visitor.visit(this, value);
    }

    @Override
    public IteratingBuilder copy(boolean includeChildren) {
        return new IteratingBuilder(this, includeChildren);
    }
}

