/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.visitors;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.JSONFieldSupport;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilderUtils;
import org.geoserver.featurestemplating.builders.impl.ArrayIncludeFlatBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicIncludeFlatBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicJsonBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicMergeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.IteratingBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.builders.selectionwrappers.CompositePropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.DynamicPropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.IncludeArrayPropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.IncludeFlatPropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.IteratingPropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.MergePropertySelection;
import org.geoserver.featurestemplating.builders.selectionwrappers.PropertySelectionWrapper;
import org.geoserver.featurestemplating.builders.selectionwrappers.StaticPropertySelection;
import org.geoserver.featurestemplating.builders.visitors.DuplicatingTemplateVisitor;
import org.geoserver.featurestemplating.builders.visitors.PropertySelectionContext;
import org.geoserver.featurestemplating.builders.visitors.PropertySelectionHandler;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.feature.type.PropertyType;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.util.logging.Logging;

public class PropertySelectionVisitor
extends DuplicatingTemplateVisitor {
    private PropertySelectionHandler selectionHandler;
    private PropertyType propertyType;
    private FilterAttributeExtractor extractor;
    private Set<String> queryProperties;
    private static final Logger LOGGER = Logging.getLogger(PropertySelectionVisitor.class);

    public PropertySelectionVisitor(PropertySelectionHandler selectionHandler, PropertyType propertyType) {
        this.selectionHandler = selectionHandler;
        this.propertyType = propertyType;
        this.extractor = new FilterAttributeExtractor();
        this.queryProperties = new HashSet<String>();
    }

    @Override
    public Object visit(IteratingBuilder iteratingBuilder, Object extradata) {
        PropertySelectionContext selectionExtradata = this.createExtradata(iteratingBuilder, extradata);
        IteratingBuilder copy = (IteratingBuilder)super.visit(iteratingBuilder, (Object)selectionExtradata);
        return this.selectBuilder(copy, selectionExtradata);
    }

    @Override
    public Object visit(CompositeBuilder compositeBuilder, Object extradata) {
        PropertySelectionContext selectionExtradata = this.createExtradata(compositeBuilder, extradata);
        CompositeBuilder copy = (CompositeBuilder)super.visit(compositeBuilder, (Object)selectionExtradata);
        return this.selectBuilder(copy, selectionExtradata);
    }

    @Override
    public Object visit(DynamicValueBuilder dynamicBuilder, Object extradata) {
        Object result;
        if (dynamicBuilder instanceof DynamicMergeBuilder) {
            result = this.visit((DynamicMergeBuilder)dynamicBuilder, extradata);
        } else if (dynamicBuilder instanceof DynamicIncludeFlatBuilder) {
            result = this.visit((DynamicIncludeFlatBuilder)dynamicBuilder, extradata);
        } else {
            PropertySelectionContext selectionExtradata = this.createExtradata(dynamicBuilder, extradata);
            DynamicValueBuilder copy = (DynamicValueBuilder)super.visit(dynamicBuilder, (Object)selectionExtradata);
            AbstractTemplateBuilder builder = this.selectBuilder(copy, selectionExtradata);
            result = this.wrapJsonValuesBuilder(builder, selectionExtradata);
        }
        return result;
    }

    @Override
    public Object visit(StaticBuilder staticBuilder, Object extradata) {
        PropertySelectionContext selectionExtradata = this.createExtradata(staticBuilder, extradata);
        StaticBuilder copy = (StaticBuilder)super.visit(staticBuilder, (Object)selectionExtradata);
        AbstractTemplateBuilder builder = this.selectBuilder(copy, selectionExtradata);
        return this.wrapJsonValuesBuilder(builder, selectionExtradata);
    }

    @Override
    public Object visit(DynamicMergeBuilder merge, Object extradata) {
        PropertySelectionContext selectionExtradata = this.createExtradata(merge, extradata);
        DynamicMergeBuilder copy = (DynamicMergeBuilder)super.visit(merge, (Object)selectionExtradata);
        AbstractTemplateBuilder builder = this.selectBuilder(copy, selectionExtradata);
        if (builder != null) {
            builder = new MergePropertySelection((DynamicMergeBuilder)builder, this.selectionHandler);
        }
        return builder;
    }

    @Override
    public Object visit(DynamicIncludeFlatBuilder includeFlat, Object extradata) {
        PropertySelectionContext selectionExtradata = this.createExtradata(includeFlat, extradata);
        DynamicIncludeFlatBuilder copy = (DynamicIncludeFlatBuilder)super.visit(includeFlat, (Object)selectionExtradata);
        return this.selectBuilder(copy, selectionExtradata);
    }

    public Set<String> getQueryProperties() {
        return this.queryProperties;
    }

    private boolean hasDynamicKey(AbstractTemplateBuilder builder) {
        boolean result = false;
        Expression expression = builder.getKey();
        if (expression != null) {
            expression.accept((ExpressionVisitor)this.extractor, null);
            result = !this.extractor.isConstantExpression();
        }
        return result;
    }

    private PropertySelectionWrapper wrapWhenNonStaticKey(AbstractTemplateBuilder builder) {
        PropertySelectionWrapper result = null;
        if (builder instanceof DynamicIncludeFlatBuilder) {
            result = new IncludeFlatPropertySelection((DynamicIncludeFlatBuilder)builder, this.selectionHandler);
        } else if (builder instanceof ArrayIncludeFlatBuilder) {
            result = new IncludeArrayPropertySelection((ArrayIncludeFlatBuilder)builder, this.selectionHandler);
        } else {
            boolean wrap = this.hasDynamicKey(builder);
            if (builder instanceof DynamicValueBuilder && wrap) {
                DynamicValueBuilder dynamic = (DynamicValueBuilder)builder;
                result = new DynamicPropertySelection(dynamic, this.selectionHandler);
            } else if (builder instanceof StaticBuilder && wrap) {
                StaticBuilder staticBuilder = (StaticBuilder)builder;
                result = new StaticPropertySelection(staticBuilder, this.selectionHandler);
            } else if (wrap && builder instanceof CompositeBuilder) {
                result = new CompositePropertySelection((CompositeBuilder)builder, this.selectionHandler);
            } else if (wrap && builder instanceof IteratingBuilder) {
                result = new IteratingPropertySelection((AbstractTemplateBuilder)((IteratingBuilder)builder), this.selectionHandler);
            }
        }
        return result;
    }

    private AbstractTemplateBuilder wrapJsonValuesBuilder(AbstractTemplateBuilder builder, PropertySelectionContext extradata) {
        if (builder instanceof StaticBuilder) {
            builder = this.wrapStaticBuilder((StaticBuilder)builder, extradata);
        } else if (builder instanceof DynamicValueBuilder) {
            this.queryProperties.addAll(this.extractSelectedProperties(builder, extradata));
            builder = this.wrapDynamicBuilder((DynamicValueBuilder)builder, extradata);
        }
        return builder;
    }

    private AbstractTemplateBuilder wrapStaticBuilder(StaticBuilder builder, PropertySelectionContext extradata) {
        AbstractTemplateBuilder result = builder;
        JsonNode jsonValue = builder.getStaticValue();
        if (jsonValue != null && !jsonValue.isValueNode() && this.selectionHandler.hasSelectableJsonValue(builder)) {
            StaticPropertySelection wrapper = new StaticPropertySelection(builder, this.selectionHandler);
            if (!extradata.isDynamicKeyParent()) {
                wrapper.setFullKey(extradata.getStaticFullKey());
            }
            result = wrapper;
        }
        return result;
    }

    private AbstractTemplateBuilder wrapDynamicBuilder(DynamicValueBuilder builder, PropertySelectionContext extradata) {
        AbstractTemplateBuilder result = builder;
        if (this.hasJsonField(builder) && this.selectionHandler.hasSelectableJsonValue(builder)) {
            DynamicPropertySelection wrapper = new DynamicPropertySelection(builder, this.selectionHandler);
            if (!extradata.isDynamicKeyParent()) {
                wrapper.setFullKey(extradata.getStaticFullKey());
            }
            result = wrapper;
        }
        return result;
    }

    private Set<PropertyName> extractPropertyNames(DynamicValueBuilder dynamicValueBuilder) {
        Set<Object> props;
        if (dynamicValueBuilder.getXpath() != null) {
            props = new HashSet<PropertyName>();
            props.add((PropertyName)dynamicValueBuilder.getXpath());
        } else {
            FilterAttributeExtractor extractor = new FilterAttributeExtractor();
            dynamicValueBuilder.getCql().accept((ExpressionVisitor)extractor, null);
            props = extractor.getPropertyNameSet();
            extractor.clear();
        }
        return props;
    }

    private boolean hasJsonField(DynamicValueBuilder valueBuilder) {
        Set<PropertyName> propertyNames = this.extractPropertyNames(valueBuilder);
        boolean result = false;
        for (PropertyName pn : propertyNames) {
            Object evalRes = pn.evaluate((Object)this.propertyType);
            if (!(evalRes instanceof PropertyDescriptor)) continue;
            result = JSONFieldSupport.isJSONField((PropertyDescriptor)evalRes);
            break;
        }
        return result;
    }

    private AbstractTemplateBuilder selectBuilder(AbstractTemplateBuilder templateBuilder, PropertySelectionContext extradata) {
        PropertySelectionWrapper runtimeSelection = this.wrapWhenNonStaticKey(templateBuilder);
        if (runtimeSelection != null) {
            extradata.setDynamicKeyCurrent(true);
            if (!extradata.isDynamicKeyParent()) {
                runtimeSelection.setFullKey(extradata.getStaticFullKey());
                templateBuilder = this.selectionHandler.isBuilderSelected((AbstractTemplateBuilder)runtimeSelection, extradata) ? runtimeSelection : null;
            } else {
                templateBuilder = runtimeSelection;
            }
            if (templateBuilder != null) {
                Set<String> props = this.extractSelectedProperties(runtimeSelection.getDelegate(), extradata);
                this.queryProperties.addAll(props);
            }
        } else {
            boolean isSelected = this.selectionHandler.isBuilderSelected(templateBuilder, extradata);
            if (!isSelected) {
                templateBuilder = null;
            } else {
                this.queryProperties.addAll(this.extractSelectedProperties(templateBuilder, extradata));
            }
        }
        return templateBuilder;
    }

    private PropertySelectionContext createExtradata(TemplateBuilder current, Object extradata) {
        PropertySelectionContext selectionExtradata = extradata instanceof PropertySelectionContext ? new PropertySelectionContext((PropertySelectionContext)extradata) : new PropertySelectionContext();
        if (current instanceof AbstractTemplateBuilder && !selectionExtradata.isDynamicKeyParent()) {
            this.updateFullStaticKey((AbstractTemplateBuilder)current, selectionExtradata);
        }
        return selectionExtradata;
    }

    private void updateFullStaticKey(AbstractTemplateBuilder abstractBuilder, PropertySelectionContext selectionExtradata) {
        boolean hasValidKey = TemplateBuilderUtils.hasSelectableKey(abstractBuilder);
        if (hasValidKey) {
            boolean dynamicKey = this.hasDynamicKey(abstractBuilder);
            if (dynamicKey) {
                selectionExtradata.setDynamicKeyCurrent(true);
            } else {
                String currentFullKey = selectionExtradata.getStaticFullKey();
                String key = abstractBuilder.getKey(null);
                if (currentFullKey != null && key != null) {
                    selectionExtradata.setStaticFullKey(currentFullKey.concat(".").concat(key));
                } else if (key != null) {
                    selectionExtradata.setStaticFullKey(key);
                }
            }
        }
    }

    private Set<String> extractSelectedProperties(AbstractTemplateBuilder templateBuilder, PropertySelectionContext context) {
        Set<String> result = Collections.emptySet();
        if (templateBuilder instanceof DynamicJsonBuilder) {
            DynamicJsonBuilder jsonBuilder = (DynamicJsonBuilder)templateBuilder;
            result = this.getPropertiesFromDynamicJsonBuilder(jsonBuilder, context);
        } else if (templateBuilder instanceof DynamicValueBuilder) {
            result = this.getPropertiesFromDynamic((DynamicValueBuilder)templateBuilder);
        } else if (templateBuilder instanceof SourceBuilder) {
            SourceBuilder sourceBuilder = (SourceBuilder)templateBuilder;
            result = this.getPropertiesFromSourceBuilder(sourceBuilder);
        }
        if (this.hasDynamicKey(templateBuilder)) {
            Set<String> props = this.getPropertiesFromDynamicKey(templateBuilder);
            if (result.isEmpty()) {
                result = props;
            } else {
                result.addAll(props);
            }
        }
        return result;
    }

    private Set<String> getPropertiesFromDynamicJsonBuilder(DynamicJsonBuilder dynamicJsonBuilder, PropertySelectionContext context) {
        HashSet<String> props = new HashSet<String>(1);
        if (dynamicJsonBuilder.getXpath() != null) {
            props.add(dynamicJsonBuilder.getXpath().getPropertyName());
        } else if (dynamicJsonBuilder.getCql() != null) {
            dynamicJsonBuilder.getCql().accept((ExpressionVisitor)this.extractor, (Object)this.createExtradata(dynamicJsonBuilder, context));
        }
        props.addAll(this.extractor.getAttributeNameSet());
        this.logQueryAttributes(dynamicJsonBuilder, true, this.extractor.getAttributeNameSet());
        this.extractor.clear();
        this.extractor.getPropertyNameSet().clear();
        if (!context.isDynamicKeyParent()) {
            JsonNode jsonNode = dynamicJsonBuilder.getNode();
            JsonNode node = this.selectionHandler.pruneJsonAttributes(jsonNode, context.getStaticFullKey());
            TemplateBuilder tb = dynamicJsonBuilder.getNestedTree(node, null);
            tb.accept(this, context);
        }
        return props;
    }

    private void logQueryAttributes(AbstractTemplateBuilder templateBuilder, boolean includeKey, Set<String> attributes) {
        if (LOGGER.isLoggable(Level.FINE)) {
            boolean hasAttributes;
            includeKey = includeKey && !(templateBuilder instanceof DynamicIncludeFlatBuilder);
            StringBuilder logMsg = new StringBuilder("Found ");
            boolean bl = hasAttributes = attributes != null && !attributes.isEmpty();
            if (hasAttributes) {
                logMsg.append(" the following ");
            } else {
                logMsg.append(" 0 ");
            }
            logMsg.append("query properties for builder with type ").append(templateBuilder.getClass().getSimpleName());
            if (includeKey) {
                String key = templateBuilder.getKey(null);
                logMsg.append(" and with ");
                if (key == null) {
                    logMsg.append("null key");
                } else {
                    logMsg.append("key ").append(key);
                }
            }
            if (hasAttributes) {
                logMsg.append(": ").append(attributes.stream().collect(Collectors.joining(",")));
            }
        }
    }

    private Set<String> getPropertiesFromDynamic(DynamicValueBuilder dynamicValueBuilder) {
        HashSet<String> props = new HashSet<String>(1);
        if (dynamicValueBuilder.getXpath() != null) {
            props.add(dynamicValueBuilder.getXpath().getPropertyName());
        } else if (dynamicValueBuilder.getCql() != null) {
            dynamicValueBuilder.getCql().accept((ExpressionVisitor)this.extractor, null);
        }
        props.addAll(this.extractor.getAttributeNameSet());
        this.logQueryAttributes(dynamicValueBuilder, true, this.extractor.getAttributeNameSet());
        this.extractor.clear();
        this.extractor.getPropertyNameSet().clear();
        return props;
    }

    private Set<String> getPropertiesFromSourceBuilder(SourceBuilder sourceBuilder) {
        HashSet<String> props = new HashSet<String>(1);
        if (sourceBuilder.getSource() != null) {
            sourceBuilder.getSource().accept((ExpressionVisitor)this.extractor, null);
            props.addAll(this.extractor.getAttributeNameSet());
            this.logQueryAttributes(sourceBuilder, true, this.extractor.getAttributeNameSet());
            this.extractor.clear();
            this.extractor.getPropertyNameSet().clear();
        }
        return props;
    }

    private Set<String> getPropertiesFromDynamicKey(AbstractTemplateBuilder templateBuilder) {
        HashSet<String> props = new HashSet<String>(1);
        Expression exp = templateBuilder.getKey();
        if (exp != null) {
            exp.accept((ExpressionVisitor)this.extractor, null);
        }
        props.addAll(this.extractor.getAttributeNameSet());
        this.logQueryAttributes(templateBuilder, false, this.extractor.getAttributeNameSet());
        return props;
    }
}

