/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.util.Arrays;
import java.util.List;

public enum SupportedFormat {
    JSONLD("JSON-LD"),
    GML("GML"),
    GEOJSON("GeoJSON"),
    HTML("HTML");

    private String format;

    private SupportedFormat(String format) {
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public static List<SupportedFormat> getByExtension(String extension) {
        if (extension == null) {
            return Arrays.asList(SupportedFormat.values());
        }
        if (extension.equals("xml")) {
            return Arrays.asList(GML);
        }
        if (extension.equals("xhtml")) {
            return Arrays.asList(HTML);
        }
        return Arrays.asList(JSONLD, GEOJSON);
    }
}

