/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.util.URI;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.visitors.SimplifiedPropertyReplacer;
import org.geoserver.featurestemplating.configuration.Template;
import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.featurestemplating.configuration.TemplateInfoDAO;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.configuration.TemplateRuleService;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.featurestemplating.validation.TemplateValidator;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class TemplateLoader {
    private final LoadingCache<CacheKey, Template> templateCache;
    private GeoServerDataDirectory dataDirectory;

    public TemplateLoader(GeoServerDataDirectory dd) {
        this.dataDirectory = dd;
        this.templateCache = CacheBuilder.newBuilder().maximumSize(100L).initialCapacity(1).expireAfterAccess(120L, TimeUnit.MINUTES).build((CacheLoader)new TemplateCacheLoader());
    }

    public RootBuilder getTemplate(FeatureTypeInfo typeInfo, String outputFormat, Request request) throws ExecutionException {
        String templateIdentifier;
        String string = templateIdentifier = request == null ? this.evaluatesTemplateRule(typeInfo) : this.evaluatesTemplateRule(typeInfo, request);
        if (templateIdentifier == null) {
            templateIdentifier = TemplateIdentifier.fromOutputFormat(outputFormat).getFilename();
        }
        return this.getTemplateByIdentifier(typeInfo, templateIdentifier);
    }

    public RootBuilder getTemplate(FeatureTypeInfo typeInfo, String outputFormat) throws ExecutionException {
        return this.getTemplate(typeInfo, outputFormat, null);
    }

    private RootBuilder getTemplateByIdentifier(FeatureTypeInfo typeInfo, String templateIdentifier) throws ExecutionException {
        TemplateValidator validator;
        boolean isValid;
        CacheKey key = new CacheKey(typeInfo, templateIdentifier);
        Template template = (Template)this.templateCache.get((Object)key);
        boolean updateCache = false;
        if (template.checkTemplate()) {
            updateCache = true;
        }
        RootBuilder root = template.getRootBuilder();
        if (updateCache) {
            this.replaceSimplifiedPropertiesIfNeeded(key.getResource(), template.getRootBuilder());
            this.templateCache.put((Object)key, (Object)template);
        }
        if (root != null && !(isValid = (validator = new TemplateValidator(typeInfo)).validateTemplate(root))) {
            throw new RuntimeException("Failed to validate template for feature type " + typeInfo.getName() + ". Failing attribute is " + URI.decode((String)validator.getFailingAttribute()));
        }
        return root;
    }

    private NamespaceSupport declareNamespaces(FeatureType type) {
        Map namespaces;
        NamespaceSupport namespaceSupport = null;
        if (type instanceof ComplexFeatureTypeImpl && (namespaces = (Map)type.getUserData().get("declaredNamespacesMap")) != null) {
            namespaceSupport = new NamespaceSupport();
            for (Map.Entry entry : namespaces.entrySet()) {
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                namespaceSupport.declarePrefix(prefix, namespace);
            }
        }
        return namespaceSupport;
    }

    GeoServerDataDirectory getDataDirectory() {
        return this.dataDirectory;
    }

    private void replaceSimplifiedPropertiesIfNeeded(FeatureTypeInfo featureTypeInfo, RootBuilder rootBuilder) {
        try {
            DataAccessRegistry registry;
            FeatureTypeMapping featureTypeMapping;
            if (featureTypeInfo.getFeatureType() instanceof ComplexFeatureTypeImpl && rootBuilder != null && (featureTypeMapping = (registry = AppSchemaDataAccessRegistry.getInstance()).mappingByElement(featureTypeInfo.getQualifiedNativeName())) != null) {
                SimplifiedPropertyReplacer visitor = new SimplifiedPropertyReplacer(featureTypeMapping);
                rootBuilder.accept(visitor, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String evaluatesTemplateRule(FeatureTypeInfo featureTypeInfo) {
        return this.evaluatesTemplateRule(featureTypeInfo, (Request)Dispatcher.REQUEST.get());
    }

    private String evaluatesTemplateRule(FeatureTypeInfo featureTypeInfo, Request request) {
        int size;
        ArrayList<TemplateRule> matching = new ArrayList<TemplateRule>();
        TemplateRuleService ruleService = new TemplateRuleService(featureTypeInfo);
        Set<TemplateRule> rules = ruleService.getRules();
        String result = null;
        if (rules != null && !rules.isEmpty()) {
            for (TemplateRule r : rules) {
                if (!r.applyRule(request)) continue;
                matching.add(r);
            }
        }
        if ((size = matching.size()) > 0) {
            result = this.getHighestPriorityIdentifier(matching);
        }
        return result;
    }

    private String getHighestPriorityIdentifier(List<TemplateRule> rules) {
        if (rules.size() > 1) {
            TemplateRule.TemplateRuleComparator comparator = new TemplateRule.TemplateRuleComparator();
            rules.sort(comparator);
        }
        return rules.get(0).getTemplateIdentifier();
    }

    public void cleanCache(FeatureTypeInfo fti, String templateIdentifier) {
        CacheKey key = new CacheKey(fti, templateIdentifier);
        if (this.templateCache.getIfPresent((Object)key) != null) {
            this.templateCache.invalidate((Object)key);
        }
    }

    public void removeAllWithIdentifier(String templateIdentifier) {
        Set keys = this.templateCache.asMap().keySet();
        for (CacheKey key : keys) {
            if (!key.getTemplateIdentifier().equals(templateIdentifier)) continue;
            this.templateCache.invalidate((Object)key);
        }
    }

    private TemplateFileManager getTemplateFileManager() {
        return TemplateFileManager.get();
    }

    public void reset() {
        this.templateCache.invalidateAll();
    }

    public static TemplateLoader get() {
        return (TemplateLoader)GeoServerExtensions.bean(TemplateLoader.class);
    }

    private class TemplateCacheLoader
    extends CacheLoader<CacheKey, Template> {
        private TemplateCacheLoader() {
        }

        public Template load(CacheKey key) {
            NamespaceSupport namespaces = null;
            try {
                FeatureType type = key.getResource().getFeatureType();
                namespaces = TemplateLoader.this.declareNamespaces(type);
            }
            catch (IOException e) {
                throw new RuntimeException("Error retrieving FeatureType " + key.getResource().getName() + "Exception is: " + e.getMessage());
            }
            TemplateInfo templateInfo = TemplateInfoDAO.get().findById(key.getTemplateIdentifier());
            Resource resource = templateInfo != null ? TemplateLoader.this.getTemplateFileManager().getTemplateResource(templateInfo) : TemplateLoader.this.getDataDirectory().get((ResourceInfo)key.getResource(), new String[]{key.getTemplateIdentifier()});
            Template template = new Template(resource, new TemplateReaderConfiguration(namespaces));
            RootBuilder builder = template.getRootBuilder();
            if (builder != null) {
                TemplateLoader.this.replaceSimplifiedPropertiesIfNeeded(key.getResource(), builder);
            }
            return template;
        }
    }

    private class CacheKey {
        private FeatureTypeInfo resource;
        private String templateIdentifier;

        public CacheKey(FeatureTypeInfo resource, String templateIdentifier) {
            this.resource = resource;
            this.templateIdentifier = templateIdentifier;
        }

        public FeatureTypeInfo getResource() {
            return this.resource;
        }

        public String getTemplateIdentifier() {
            return this.templateIdentifier;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.getTemplateIdentifier().equals(this.templateIdentifier)) {
                return false;
            }
            if (!other.getResource().getName().equals(this.resource.getName())) {
                return false;
            }
            return other.getResource().getNamespace().equals((Object)this.resource.getNamespace());
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.templateIdentifier);
        }
    }
}

