/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.featurestemplating.expressions.RequestFunction;
import org.geoserver.ows.Request;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.capability.FunctionNameImpl;

public class RequestMatchRegex
extends RequestFunction {
    public static FunctionName NAME = new FunctionNameImpl("requestMatchRegex", FunctionNameImpl.parameter((String)"result", Boolean.class), new Parameter[]{FunctionNameImpl.parameter((String)"regex", String.class)});

    public RequestMatchRegex() {
        super(NAME);
    }

    @Override
    protected Object evaluateInternal(Request request, Object object) {
        String regex = (String)((Expression)this.getParameters().get(0)).evaluate(null, String.class);
        Pattern pattern = Pattern.compile(regex);
        String url = this.getFullURL(request.getHttpRequest());
        Matcher matcher = pattern.matcher(url);
        return matcher.matches();
    }

    private String getFullURL(HttpServletRequest request) {
        StringBuilder requestURL = new StringBuilder(ResponseUtils.baseURL((HttpServletRequest)request));
        String pathInfo = request.getPathInfo();
        String queryString = request.getQueryString();
        if (pathInfo != null) {
            if (pathInfo.startsWith("/")) {
                pathInfo = pathInfo.substring(1);
            }
            requestURL.append(pathInfo);
        }
        if (queryString != null) {
            requestURL.append("?").append(queryString);
        }
        return requestURL.toString();
    }
}

