/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions.aggregate;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.expressions.aggregate.AggregationOp;
import org.geoserver.featurestemplating.expressions.aggregate.StringCQLFunction;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.VolatileFunction;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.util.logging.Logging;

public class FilteringFunction
extends StringCQLFunction
implements VolatileFunction {
    private static final FunctionName NAME = new FunctionNameImpl("filter", FunctionNameImpl.parameter((String)"result", Object.class), new Parameter[]{FunctionNameImpl.parameter((String)"filter", String.class, (int)1, (int)1)});
    private static final Logger LOGGER = Logging.getLogger(FilteringFunction.class);

    public FilteringFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        ArrayList<Object> values = new ArrayList<Object>();
        String txtFilter = (String)this.getExpression(0).evaluate(null, String.class);
        try {
            txtFilter = this.fixLiterals(txtFilter);
            Filter filter = this.cqlToFilter(txtFilter);
            List<Object> list = AggregationOp.toListObj(object);
            for (Object o : list) {
                if (!filter.evaluate(o)) continue;
                values.add(o);
            }
        }
        catch (CQLException e) {
            throw new RuntimeException("The argument of the filter function is not a valid CQL filter");
        }
        return values;
    }

    private String fixLiterals(String textFilter) {
        StringBuilder sb = new StringBuilder();
        LOGGER.fine(() -> "Fixing literals in Filtering function...");
        for (char c : textFilter.toCharArray()) {
            if (c != '\"') {
                sb.append(c);
                continue;
            }
            LOGGER.fine(() -> "Replacing double quotes with single quotes");
            sb.append('\'');
        }
        return sb.toString();
    }
}

