/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.File;
import org.geoserver.data.test.MockData;
import org.geoserver.featurestemplating.configuration.TemplateFileManager;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class TemplateFileManagerTest
extends GeoServerSystemTestSupport {
    @Test
    public void testSave() {
        TemplateFileManager fileManager = TemplateFileManager.get();
        TemplateInfo info = new TemplateInfo();
        info.setTemplateName("template_name_json");
        info.setExtension("json");
        String voidTemplate = "{}";
        fileManager.saveTemplateFile(info, voidTemplate);
        File templateFile = fileManager.getTemplateResource(info).file();
        Assert.assertTrue((boolean)templateFile.exists());
        File dir = fileManager.getTemplateLocation(info);
        Assert.assertTrue((boolean)dir.getPath().endsWith("features-templating"));
        templateFile.delete();
    }

    @Test
    public void testSaveInWorkspace() {
        TemplateFileManager fileManager = TemplateFileManager.get();
        TemplateInfo info = new TemplateInfo();
        info.setTemplateName("template_name_json");
        info.setWorkspace(MockData.CITE_PREFIX);
        info.setExtension("json");
        String voidTemplate = "{}";
        fileManager.saveTemplateFile(info, voidTemplate);
        File templateFile = fileManager.getTemplateResource(info).file();
        Assert.assertTrue((boolean)templateFile.exists());
        File dir = fileManager.getTemplateLocation(info);
        Assert.assertTrue((boolean)dir.getPath().endsWith("cite"));
        templateFile.delete();
    }

    @Test
    public void testSaveInFeatureTypeInfo() {
        TemplateFileManager fileManager = TemplateFileManager.get();
        TemplateInfo info = new TemplateInfo();
        info.setTemplateName("template_name_json");
        info.setWorkspace(MockData.CDF_PREFIX);
        info.setFeatureType(MockData.FIFTEEN.getLocalPart());
        info.setExtension("json");
        String voidTemplate = "{}";
        fileManager.saveTemplateFile(info, voidTemplate);
        File templateFile = fileManager.getTemplateResource(info).file();
        Assert.assertTrue((boolean)templateFile.exists());
        File dir = fileManager.getTemplateLocation(info);
        Assert.assertTrue((boolean)dir.getPath().endsWith(MockData.FIFTEEN.getLocalPart()));
        templateFile.delete();
    }
}

