/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateRule;
import org.geoserver.featurestemplating.configuration.TemplateRuleService;
import org.geoserver.test.GeoServerSystemTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class TemplateRuleServiceTest
extends GeoServerSystemTestSupport {
    @Test
    public void testMultipleSave() {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo typeInfo = catalog.getFeatureTypeByName(MockData.CDF_PREFIX, MockData.FIFTEEN.getLocalPart());
        TemplateRuleService ruleService = new TemplateRuleService(typeInfo);
        TemplateRule rule = new TemplateRule();
        rule.setOutputFormat(SupportedFormat.HTML);
        rule.setTemplateName("html-fifteen-template");
        ruleService.saveRule(rule);
        TemplateRule rule2 = new TemplateRule();
        rule2.setOutputFormat(SupportedFormat.GEOJSON);
        rule2.setTemplateName("geojson-fifteen-template");
        ruleService.saveRule(rule2);
        Set rules = ruleService.getRules();
        Assert.assertEquals((long)2L, (long)rules.size());
        Assert.assertTrue((boolean)rules.stream().anyMatch(r -> r.getOutputFormat().equals((Object)SupportedFormat.GEOJSON)));
        Assert.assertTrue((boolean)rules.stream().anyMatch(r -> r.getOutputFormat().equals((Object)SupportedFormat.HTML)));
    }
}

