/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions;

import java.util.ArrayList;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.FilterFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.junit.Before;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public abstract class ListFunctionsTestSupport {
    protected static FilterFactory ff = CommonFactoryFinder.getFilterFactory();
    protected List<SimpleFeature> featureList = new ArrayList<SimpleFeature>();

    @Before
    public void setup() {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.add("stringValue", String.class);
        tb.add("doubleValue", Double.class);
        tb.add("intValue", Integer.class);
        tb.add("dupProperty", String.class);
        tb.add("geometry", Point.class);
        tb.setName("listFunTest");
        SimpleFeatureType schema = tb.buildFeatureType();
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(schema);
        GeometryFactory factory = new GeometryFactory();
        for (int i = 1; i < 10; ++i) {
            fb.add((Object)this.getCharForNumber(i));
            fb.add((Object)Double.valueOf(i + "." + i));
            fb.add((Object)i);
            if (i % 2 == 0) {
                fb.add((Object)"even");
            } else {
                fb.add((Object)"odd");
            }
            fb.add((Object)factory.createPoint(new Coordinate((double)i, (double)i)));
            this.featureList.add(fb.buildFeature(null));
        }
    }

    private String getCharForNumber(int i) {
        return i > 0 && i < 27 ? String.valueOf((char)(i + 64)) : null;
    }
}

