/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.readers.JSONMerger;
import org.geoserver.featurestemplating.readers.JSONTemplateReader;
import org.geoserver.featurestemplating.readers.RecursiveJSONParser;
import org.geoserver.featurestemplating.readers.TemplateReaderConfiguration;
import org.geoserver.platform.resource.FileSystemResourceStore;
import org.geoserver.platform.resource.Resource;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.helpers.NamespaceSupport;

public class JSONMergesTest {
    FileSystemResourceStore store;

    @Before
    public void setupStore() {
        this.store = new FileSystemResourceStore(new File("src/test/resources/jsonMerge"));
    }

    @Test
    public void testRecursionLimited() {
        RuntimeException ex = this.checkThrowingTemplate("recurse.json");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Went beyond maximum expansion depth (51), chain is: [recurse.json"));
    }

    @Test
    public void testDanglingInclude() {
        RuntimeException ex = this.checkThrowingTemplate("dangling.json");
        Assert.assertEquals((Object)"$merge resource notThere.json could not be found", (Object)ex.getMessage());
    }

    @Test
    public void testRecursionPingPong() {
        RuntimeException ex = this.checkThrowingTemplate("ping.json");
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"Went beyond maximum expansion depth (51), chain is: [ping.json"));
        MatcherAssert.assertThat((Object)ex.getMessage(), (Matcher)CoreMatchers.containsString((String)"pong.json"));
    }

    private RuntimeException checkThrowingTemplate(String s) {
        return (RuntimeException)Assert.assertThrows(RuntimeException.class, () -> new RecursiveJSONParser(this.store.get(s)).parse());
    }

    @Test
    public void testSimpleMerge() throws IOException {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("simpleOverride.json"));
        ObjectNode parsed = (ObjectNode)parser.parse();
        Assert.assertEquals((Object)JsonNodeType.OBJECT, (Object)parsed.get("a").getNodeType());
        ObjectNode a = (ObjectNode)parsed.get("a");
        Assert.assertEquals((long)1L, (long)a.get("a1").intValue());
        Assert.assertEquals((long)2L, (long)a.get("a2").intValue());
        Assert.assertFalse((boolean)parsed.has("b"));
        Assert.assertEquals((Object)JsonNodeType.STRING, (Object)parsed.get("c").getNodeType());
        Assert.assertEquals((Object)"theCValue", (Object)parsed.get("c").textValue());
        Assert.assertEquals((Object)JsonNodeType.STRING, (Object)parsed.get("array").getNodeType());
        Assert.assertEquals((Object)"notAnArray", (Object)parsed.get("array").textValue());
    }

    @Test
    public void testEOExample() throws IOException {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("eoOverride.json"));
        ObjectNode parsed = (ObjectNode)parser.parse();
        ArrayNode array = (ArrayNode)parsed.get("features");
        ObjectNode feature = (ObjectNode)array.get(0);
        Assert.assertEquals((Object)"Feature", (Object)feature.get("type").textValue());
        Assert.assertEquals((Object)"${eop:identifier}", (Object)feature.get("id").textValue());
        ObjectNode properties = (ObjectNode)feature.get("properties");
        Assert.assertEquals((Object)"Maja", (Object)properties.get("constellation").textValue());
        ArrayNode instruments = (ArrayNode)properties.get("instruments");
        Assert.assertEquals((Object)"myMajaInstrument1", (Object)instruments.get(0).textValue());
        Assert.assertEquals((Object)"myMajaInstrument2", (Object)instruments.get(1).textValue());
    }

    @Test
    public void testMergeModificationsAreDetected() throws IOException, InterruptedException {
        RecursiveJSONParser parser = new RecursiveJSONParser(this.store.get("simpleOverride.json"));
        TemplateReaderConfiguration configuration = new TemplateReaderConfiguration(new NamespaceSupport());
        JSONTemplateReader reader = new JSONTemplateReader(parser.parse(), configuration, parser.getWatchers());
        RootBuilder rootBuilder = reader.getRootBuilder();
        Assert.assertFalse((boolean)rootBuilder.needsReload());
        Resource mergeBase = this.store.get("simpleBase.json");
        File file = mergeBase.file();
        file.setLastModified(new Date().getTime());
        JSONMergesTest.assertReloadNeeded(rootBuilder);
    }

    public static void assertReloadNeeded(RootBuilder rootBuilder) throws InterruptedException {
        for (int i = 0; i < 600; ++i) {
            if (rootBuilder.needsReload()) {
                return;
            }
            Thread.sleep(100L);
        }
        Assert.fail((String)"Should have found a reload 60 seconds, but did not");
    }

    @Test
    public void testEncodeDynamicMergeKeys() throws JsonProcessingException {
        String base = "{\"metadata\":{\"metadata_iso_19139\":{\"title\":\"basetext\",\"href\":\"basehref\",\"type\":\"basetype\"}}}";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode baseNode = mapper.readTree(base);
        JSONMerger jsonMerger = new JSONMerger();
        JsonNode overlay = new ObjectMapper().readTree("{\"metadata\":\"${dynamicMetadata}\"}");
        ObjectNode mergedNode = jsonMerger.mergeTrees(baseNode, overlay);
        JsonNode dynamicMerge = mergedNode.get("$dynamicMerge_metadata");
        JsonNode metadataNode = dynamicMerge.get("metadata");
        Assert.assertTrue((boolean)metadataNode.has("overlay"));
        Assert.assertTrue((boolean)metadataNode.has("base"));
    }
}

