/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Optional;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.api.feature.type.PropertyDescriptor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.function.JsonPointerFunction;
import org.geotools.util.Converters;
import org.geotools.util.logging.Logging;

public class JSONFieldSupport {
    static final Logger LOGGER = Logging.getLogger(JSONFieldSupport.class);
    public static final String JDBC_NATIVE_TYPENAME = "org.geotools.jdbc.nativeTypeName";
    private static ObjectMapper MAPPER = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
    public static ObjectMapper SORT_BY_KEY_MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new JsonParser.Feature[]{JsonParser.Feature.ALLOW_COMMENTS})).nodeFactory((JsonNodeFactory)new SortingNodeFactory())).build();

    public static Object parseWhenJSON(Expression expression, Object contextObject, Object result) {
        try {
            if (contextObject instanceof ComplexAttribute ? expression instanceof JsonPointerFunction || JSONFieldSupport.isJSONField(Optional.ofNullable(((ComplexAttribute)contextObject).getType()).map(ct -> expression.evaluate(ct)).filter(d -> d instanceof PropertyDescriptor).map(d -> (PropertyDescriptor)d)) : result instanceof Attribute && JSONFieldSupport.isJSONField(Optional.of(((Attribute)result).getDescriptor()))) {
                return JSONFieldSupport.parseJSON(result);
            }
        }
        catch (JsonProcessingException ex) {
            LOGGER.log(Level.FINE, "Failed to parse JSON from attribute that was supposed to be a JSON field");
        }
        return result;
    }

    public static boolean isJSONField(PropertyDescriptor opd) {
        return JSONFieldSupport.isJSONField(Optional.ofNullable(opd));
    }

    public static boolean isJSONBField(PropertyDescriptor opd) {
        return JSONFieldSupport.isJSONBField(Optional.ofNullable(opd));
    }

    private static boolean isJSONField(Optional<PropertyDescriptor> opd) {
        return opd.map(pd -> pd.getUserData().get(JDBC_NATIVE_TYPENAME)).filter(t -> t instanceof String).map(t -> (String)t).filter(t -> JSONFieldSupport.matchesJSONType(t)).isPresent();
    }

    private static boolean isJSONBField(Optional<PropertyDescriptor> opd) {
        return opd.map(pd -> pd.getUserData().get(JDBC_NATIVE_TYPENAME)).filter(t -> t instanceof String).map(t -> (String)t).filter(t -> JSONFieldSupport.matchesJSONBType(t)).isPresent();
    }

    private static boolean matchesJSONType(String type) {
        return "JSON".equalsIgnoreCase(type) || "JSONB".equalsIgnoreCase(type);
    }

    private static boolean matchesJSONBType(String type) {
        return "JSONB".equalsIgnoreCase(type);
    }

    public static Object parseJSON(Object value) throws JsonProcessingException {
        String json = JSONFieldSupport.getJSON(value);
        if (json != null) {
            return MAPPER.readTree(json);
        }
        return value;
    }

    private static String getJSON(Object value) {
        if (value instanceof Attribute) {
            return (String)Converters.convert((Object)((Attribute)value).getValue(), String.class);
        }
        return (String)Converters.convert((Object)value, String.class);
    }

    static class SortingNodeFactory
    extends JsonNodeFactory {
        SortingNodeFactory() {
        }

        public ObjectNode objectNode() {
            return new ObjectNode((JsonNodeFactory)this, new TreeMap());
        }
    }
}

