/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.flat;

import java.io.IOException;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.flat.AttributeNameHelper;
import org.geoserver.featurestemplating.builders.flat.FlatBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.feature.Feature;
import org.xml.sax.helpers.NamespaceSupport;

public class FlatCompositeBuilder
extends CompositeBuilder
implements FlatBuilder {
    private AttributeNameHelper attributeNameHelper;

    public FlatCompositeBuilder(String key, NamespaceSupport namespaces, String separator) {
        super(key, namespaces, false);
        this.attributeNameHelper = new AttributeNameHelper(this.key, separator);
    }

    public FlatCompositeBuilder(FlatCompositeBuilder original, boolean includeChildren) {
        super(original, includeChildren);
        this.attributeNameHelper = new AttributeNameHelper(this.key, original.attributeNameHelper.getSeparator());
    }

    public FlatCompositeBuilder(String key, NamespaceSupport namespaces, String separator, boolean topLevelComplex) {
        super(key, namespaces, topLevelComplex);
        this.attributeNameHelper = new AttributeNameHelper(this.key, separator);
    }

    @Override
    protected void evaluateChildren(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        Object o = context.getCurrentObj();
        this.addSkipObjectEncodingHint(context);
        String key = this.getKey(context);
        boolean isFeatureTypeBuilder = this.isFeatureTypeBuilder(o);
        if (isFeatureTypeBuilder || key != null && key.equals("properties")) {
            writer.startObject(key, this.encodingHints);
        }
        for (TemplateBuilder jb : this.children) {
            ((FlatBuilder)((Object)jb)).setParentKey(this.attributeNameHelper.getCompleteCompositeAttributeName());
            jb.evaluate(writer, context);
        }
        if (this.isFeatureTypeBuilder(o) || key != null && key.equals("properties")) {
            writer.endObject(key, this.encodingHints);
        }
    }

    private boolean isFeatureTypeBuilder(Object o) {
        boolean result = false;
        if (o instanceof Feature) {
            Feature f = (Feature)o;
            result = this.getStrSource() != null && this.getSource().evaluate((Object)f.getType()) == null;
        }
        return result;
    }

    @Override
    public void setParentKey(String parentKey) {
        this.attributeNameHelper.setParentKey(parentKey);
    }
}

