/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.impl;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.Objects;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.builders.visitors.TemplateVisitor;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.xml.sax.helpers.NamespaceSupport;

public class StaticBuilder
extends AbstractTemplateBuilder {
    protected JsonNode staticValue;
    protected String strValue;

    public StaticBuilder(String key, JsonNode value, NamespaceSupport namespaces) {
        super(key, namespaces);
        this.staticValue = value;
    }

    public StaticBuilder(String key, String strValue, NamespaceSupport namespaces) {
        super(key, namespaces);
        this.strValue = strValue;
    }

    public StaticBuilder(StaticBuilder original, boolean includeChildren) {
        super(original, includeChildren);
        this.strValue = original.getStrValue();
        this.staticValue = original.getStaticValue();
    }

    @Override
    public void evaluate(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        if (this.canWrite(context) && this.evaluateFilter(context)) {
            this.evaluateInternal(writer, context);
        }
    }

    protected void evaluateInternal(TemplateOutputWriter writer, TemplateBuilderContext context) throws IOException {
        this.addChildrenEvaluationToEncodingHints(writer, context);
        String key = this.getKey(context);
        if (this.strValue != null) {
            writer.writeStaticContent(key, this.strValue, this.getEncodingHints());
        } else {
            writer.writeStaticContent(key, this.staticValue, this.getEncodingHints());
        }
    }

    public JsonNode getStaticValue() {
        return this.staticValue;
    }

    public String getStrValue() {
        return this.strValue;
    }

    @Override
    public Object accept(TemplateVisitor visitor, Object value) {
        return visitor.visit(this, value);
    }

    @Override
    public StaticBuilder copy(boolean includeChildren) {
        return new StaticBuilder(this, includeChildren);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticBuilder that = (StaticBuilder)o;
        return Objects.equals(this.staticValue, that.staticValue) && Objects.equals(this.strValue, that.strValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.staticValue, this.strValue);
    }
}

