/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.selectionwrappers;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilderUtils;
import org.geoserver.featurestemplating.builders.TemplateBuilderWrapper;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.builders.visitors.PropertySelectionHandler;

public class PropertySelectionWrapper
extends TemplateBuilderWrapper {
    protected PropertySelectionHandler strategy;
    private String fullKey;

    public PropertySelectionWrapper(AbstractTemplateBuilder templateBuilder, PropertySelectionHandler propertySelectionHandler) {
        super(templateBuilder);
        this.strategy = propertySelectionHandler;
    }

    @Override
    public boolean canWrite(TemplateBuilderContext context) {
        return this.strategy.isBuilderSelected((AbstractTemplateBuilder)this, context.getCurrentObj());
    }

    public String getFullKey(TemplateBuilderContext context) {
        String key = this.getKey(context);
        if (this.fullKey != null) {
            String result = this.fullKey;
            if (key != null && !this.fullKey.endsWith(key)) {
                result = result.concat(".").concat(key);
            }
            return result;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        if (key != null) {
            linkedList.add(key);
        }
        PropertySelectionWrapper builder = this;
        for (TemplateBuilder currParent = builder.getParent(); currParent != null; currParent = currParent.getParent()) {
            AbstractTemplateBuilder parent;
            String pKey;
            if (!(currParent instanceof AbstractTemplateBuilder) || !TemplateBuilderUtils.hasSelectableKey(currParent) || (pKey = (parent = (AbstractTemplateBuilder)currParent).getKey(context)) == null) continue;
            linkedList.addFirst(pKey);
        }
        if (!linkedList.isEmpty()) {
            key = linkedList.stream().collect(Collectors.joining("."));
        }
        return key;
    }

    protected Object pruneJsonNodeIfNeeded(TemplateBuilderContext context, Object value) {
        if (value instanceof JsonNode) {
            value = this.strategy.pruneJsonAttributes((JsonNode)value, this.getFullKey(context));
        }
        return value;
    }

    public void setFullKey(String fullKey) {
        this.fullKey = fullKey;
    }
}

