/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.builders.visitors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.impl.CompositeBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.IteratingBuilder;
import org.geoserver.featurestemplating.builders.impl.StaticBuilder;
import org.geoserver.featurestemplating.builders.visitors.DefaultTemplateVisitor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.data.complex.AttributeMapping;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.NestedAttributeMapping;
import org.geotools.data.complex.config.JdbcMultipleValue;
import org.geotools.data.complex.config.MultipleValue;
import org.geotools.data.complex.filter.MultipleValueExtractor;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.util.logging.Logging;

public class SimplifiedPropertyReplacer
extends DefaultTemplateVisitor {
    static final Logger LOGGER = Logging.getLogger(SimplifiedPropertyReplacer.class);
    public static final String RELATION_MARK = "->";
    private Stack<FeatureTypeMapping> mappingsStack = new Stack();

    public SimplifiedPropertyReplacer(FeatureTypeMapping ftm) {
        this.mappingsStack.add(ftm);
    }

    @Override
    public Object visit(SourceBuilder sourceBuilder, Object extradata) {
        FeatureTypeMapping context;
        String xpath;
        String source = sourceBuilder.getStrSource();
        if (source != null && !this.mappingsStack.isEmpty() && (xpath = this.getXpathForSource(context = this.mappingsStack.peek(), source)) != null) {
            sourceBuilder.setSource(xpath);
        }
        this.replaceSimplifiedPropertyNamesInFilter(sourceBuilder, new FilterAttributeExtractor());
        sourceBuilder.getChildren().forEach(c -> c.accept(this, extradata));
        if (source != null && !this.mappingsStack.isEmpty()) {
            this.mappingsStack.pop();
        }
        return extradata;
    }

    @Override
    public Object visit(IteratingBuilder iteratingBuilder, Object extradata) {
        this.visit((SourceBuilder)iteratingBuilder, extradata);
        return extradata;
    }

    @Override
    public Object visit(CompositeBuilder compositeBuilder, Object extradata) {
        this.visit((SourceBuilder)compositeBuilder, extradata);
        return extradata;
    }

    @Override
    public Object visit(StaticBuilder staticBuilder, Object extradata) {
        this.replaceSimplifiedPropertyNamesInFilter(staticBuilder, new FilterAttributeExtractor());
        return super.visit(staticBuilder, extradata);
    }

    @Override
    public Object visit(DynamicValueBuilder dynamicBuilder, Object extradata) {
        if (!this.mappingsStack.isEmpty()) {
            Expression expression = dynamicBuilder.getCql() != null ? dynamicBuilder.getCql() : dynamicBuilder.getXpath();
            FilterAttributeExtractor extractor = new FilterAttributeExtractor();
            expression.accept((ExpressionVisitor)extractor, null);
            List<String> xpaths = this.convertSimplifiedPropertyNamesToXpaths(extractor.getAttributeNames(), dynamicBuilder.getContextPos());
            this.replaceWithXpath(xpaths, expression, dynamicBuilder);
            this.replaceSimplifiedPropertyNamesInFilter(dynamicBuilder, extractor);
        }
        return super.visit(dynamicBuilder, extradata);
    }

    private void replaceSimplifiedPropertyNamesInFilter(AbstractTemplateBuilder builder, FilterAttributeExtractor extractor) {
        Filter filter = builder.getFilter();
        if (filter != null && !this.mappingsStack.isEmpty()) {
            extractor.clear();
            filter.accept((FilterVisitor)extractor, null);
            List<String> filterXpaths = this.convertSimplifiedPropertyNamesToXpaths(extractor.getAttributeNames(), builder.getFilterContextPos());
            this.replaceWithXpath(filterXpaths, filter, builder);
        }
    }

    private List<String> convertSimplifiedPropertyNamesToXpaths(String[] strProps, int contextPos) {
        ArrayList<String> xpaths = new ArrayList<String>(strProps.length);
        try {
            FeatureTypeMapping context;
            int lastEl = this.mappingsStack.size() - 1;
            if (contextPos > 0) {
                int index = lastEl >= contextPos ? lastEl - contextPos : 0;
                context = (FeatureTypeMapping)this.mappingsStack.get(index);
            } else {
                context = this.mappingsStack.peek();
            }
            for (String p : strProps) {
                String currentXpath = "";
                String[] splitted = p.split("/");
                boolean isNested = false;
                for (String part : splitted) {
                    if (isNested) {
                        context = this.mappingsStack.pop();
                        isNested = false;
                    }
                    String xpathPart = null;
                    if (part.startsWith(RELATION_MARK)) {
                        part = part.replace(RELATION_MARK, "").replace(" ", "");
                        xpathPart = this.findMatchingXpathFromTableName(part, context.getAttributeMappings());
                    }
                    if (xpathPart != null) {
                        isNested = true;
                    } else {
                        List<AttributeMapping> filteredMappings = context.getAttributeMappings().stream().filter(m -> !(m instanceof NestedAttributeMapping)).collect(Collectors.toList());
                        xpathPart = this.findMatchingXpathInAttributeMappingList(part, filteredMappings);
                    }
                    currentXpath = this.concatXpathPart(currentXpath, xpathPart);
                }
                if (currentXpath == null || currentXpath.equals("")) continue;
                xpaths.add(currentXpath);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return xpaths;
    }

    private String getXpathForSource(FeatureTypeMapping context, String source) {
        String result;
        if (context.getSource().getName().getLocalPart().equals(source)) {
            result = this.strName(context.getTargetFeature().getName());
        } else {
            List attributeMappings = context.getAttributeMappings();
            try {
                result = this.findMatchingXpathFromTableName(source, attributeMappings);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to map source " + source + " to the proper xpath");
            }
        }
        return result;
    }

    private String findMatchingXpathFromTableName(String pathPart, List<AttributeMapping> mappings) throws IOException {
        AttributeMapping mapping;
        String result = null;
        Iterator<AttributeMapping> iterator = mappings.iterator();
        while (iterator.hasNext() && (result = (mapping = iterator.next()) instanceof NestedAttributeMapping ? this.findMatchingXpathInNested(pathPart, (NestedAttributeMapping)mapping) : this.findMatchingXpathInJdbcMultipleValue(pathPart, mapping)) == null) {
        }
        return result;
    }

    private String findMatchingXpathInNested(String pathPart, NestedAttributeMapping nested) throws IOException {
        FeatureTypeMapping ftm = nested.getFeatureTypeMapping(null);
        String result = null;
        String sourceName = ftm.getSource().getName().getLocalPart();
        if (sourceName.equals(pathPart)) {
            result = nested.getTargetXPath().toString() + "/" + this.strName(ftm.getTargetFeature().getName());
            this.mappingsStack.add(ftm);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Source " + pathPart + " mapped to " + sourceName + "  in NestedMapping");
            }
        }
        return result;
    }

    private String findMatchingXpathInJdbcMultipleValue(String pathPart, AttributeMapping attributeMapping) throws IOException {
        MultipleValueExtractor mvExtractor = new MultipleValueExtractor();
        attributeMapping.getSourceExpression().accept((ExpressionVisitor)mvExtractor, null);
        String result = null;
        List mvList = mvExtractor.getMultipleValues();
        if (mvList != null && !mvList.isEmpty()) {
            List jdbcMvList = mvList.stream().filter(mv -> mv instanceof JdbcMultipleValue).collect(Collectors.toList());
            for (MultipleValue mv2 : jdbcMvList) {
                String targetXpath;
                String tableName = ((JdbcMultipleValue)mv2).getTargetTable();
                if (!pathPart.equals(tableName)) continue;
                result = targetXpath = attributeMapping.getTargetXPath().toString();
                FeatureTypeMapping ftm = this.mappingsStack.peek();
                this.mappingsStack.add(ftm);
                if (!LOGGER.isLoggable(Level.FINE)) break;
                LOGGER.fine("Source " + pathPart + " mapped to " + targetXpath + " in JdbcMultipleValue directive");
                break;
            }
        }
        return result;
    }

    private String findMatchingXpathInAttributeMappingList(String pathPart, List<AttributeMapping> mappings) {
        String result = null;
        MultipleValueExtractor extractor = new MultipleValueExtractor();
        for (AttributeMapping mapping : mappings) {
            result = this.xpathFromAttributeMappingExpr(pathPart, extractor, mapping);
            if (result == null) {
                result = this.xpathFromClientProperties(pathPart, extractor, mapping);
            }
            if (result == null) continue;
            break;
        }
        return result;
    }

    private String xpathFromClientProperties(String pathPart, MultipleValueExtractor extractor, AttributeMapping mapping) {
        extractor.clear();
        String result = null;
        Map cProps = mapping.getClientProperties();
        for (Name xpath : cProps.keySet()) {
            Expression expression = (Expression)cProps.get(xpath);
            expression.accept((ExpressionVisitor)extractor, null);
            String[] attributeNames = extractor.getAttributeNames();
            if (attributeNames.length <= 0 || !attributeNames[0].equals(pathPart)) continue;
            result = "@" + this.strName(xpath);
            mapping.getSourceExpression().accept((ExpressionVisitor)extractor, null);
            if (mapping.getSourceExpression() instanceof JdbcMultipleValue) break;
            result = mapping.getTargetXPath().toString() + "/" + result;
            break;
        }
        return result;
    }

    private String xpathFromAttributeMappingExpr(String pathPart, MultipleValueExtractor extractor, AttributeMapping mapping) {
        MultipleValue mv;
        mapping.getSourceExpression().accept((ExpressionVisitor)extractor, null);
        String result = null;
        for (String attr : extractor.getAttributeNameSet()) {
            if (attr == null || !attr.equals(pathPart)) continue;
            result = mapping.getTargetXPath().toString();
        }
        List mvList = extractor.getMultipleValues();
        if (result == null && mvList != null && !mvList.isEmpty() && (mv = (MultipleValue)mvList.get(0)) instanceof JdbcMultipleValue) {
            Expression column = ((JdbcMultipleValue)mv).getTargetValue();
            extractor.clear();
            column.accept((ExpressionVisitor)extractor, null);
            String[] attrs = extractor.getAttributeNames();
            if (attrs.length > 0 && attrs[0].equals(pathPart)) {
                result = ".";
            }
        }
        Expression idExpr = mapping.getIdentifierExpression();
        if (result == null && idExpr != null & !idExpr.equals(Expression.NIL)) {
            extractor.clear();
            idExpr.accept((ExpressionVisitor)extractor, null);
            String[] attrs = extractor.getAttributeNames();
            if (attrs.length > 0 && attrs[0].equals(pathPart)) {
                result = "@gml:id";
            }
        }
        return result;
    }

    private void replaceWithXpath(final List<String> xpaths, Object toReplace, AbstractTemplateBuilder builder) {
        if (!xpaths.isEmpty()) {
            DuplicatingFilterVisitor dupVisitor = new DuplicatingFilterVisitor(){
                private int i = 0;

                public Object visit(PropertyName expression, Object extraData) {
                    AttributeExpressionImpl pn = new AttributeExpressionImpl((String)xpaths.get(this.i), expression.getNamespaceContext());
                    ++this.i;
                    return pn;
                }
            };
            if (toReplace instanceof Expression) {
                this.replacePropertyNamesInExpression((Expression)toReplace, dupVisitor, (DynamicValueBuilder)builder);
            } else {
                this.replacePropertyNamesInFilter((Filter)toReplace, dupVisitor, builder);
            }
        }
    }

    private void replacePropertyNamesInExpression(Expression expression, DuplicatingFilterVisitor visitor, DynamicValueBuilder builder) {
        Expression withXpath = (Expression)expression.accept((ExpressionVisitor)visitor, null);
        if (builder.getXpath() != null) {
            builder.setXpath((AttributeExpressionImpl)withXpath);
        } else {
            builder.setCql(withXpath);
        }
    }

    private void replacePropertyNamesInFilter(Filter filter, DuplicatingFilterVisitor visitor, AbstractTemplateBuilder builder) {
        Filter withXpath = (Filter)filter.accept((FilterVisitor)visitor, null);
        builder.setFilter(withXpath);
    }

    private String concatXpathPart(String xpath, String xpathPart) {
        if (xpathPart != null) {
            if (!((String)xpath).equals("")) {
                xpath = (String)xpath + "/";
            }
            xpath = (String)xpath + xpathPart;
        }
        return xpath;
    }

    private String strName(Name name) {
        String prefix = this.mappingsStack.peek().getNamespaces().getPrefix(name.getNamespaceURI());
        return prefix + name.getSeparator() + name.getLocalPart();
    }
}

