/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.util.Map;
import java.util.Objects;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeImpl;
import org.xml.sax.helpers.NamespaceSupport;

public abstract class AbstractLoader {
    protected GeoServerDataDirectory dataDirectory;

    public AbstractLoader(GeoServerDataDirectory dd) {
        this.dataDirectory = dd;
    }

    private NamespaceSupport declareNamespaces(FeatureType type) {
        Map namespaces;
        NamespaceSupport namespaceSupport = null;
        if (type instanceof ComplexFeatureTypeImpl && (namespaces = (Map)type.getUserData().get("declaredNamespacesMap")) != null) {
            namespaceSupport = new NamespaceSupport();
            for (Map.Entry entry : namespaces.entrySet()) {
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                namespaceSupport.declarePrefix(prefix, namespace);
            }
        }
        return namespaceSupport;
    }

    protected GeoServerDataDirectory getDataDirectory() {
        return this.dataDirectory;
    }

    protected class CacheKey {
        private FeatureTypeInfo resource;
        private String identifier;

        public CacheKey(FeatureTypeInfo resource, String identifier) {
            this.resource = resource;
            this.identifier = identifier;
        }

        public FeatureTypeInfo getResource() {
            return this.resource;
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey other = (CacheKey)o;
            if (!other.getIdentifier().equals(this.identifier)) {
                return false;
            }
            if (!other.getResource().getName().equals(this.resource.getName())) {
                return false;
            }
            return other.getResource().getNamespace().equals((Object)this.resource.getNamespace());
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.identifier);
        }
    }
}

