/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.platform.resource.Resource;

public abstract class FileManagerBase<T> {
    protected Catalog catalog;
    protected GeoServerDataDirectory dd;

    public FileManagerBase(Catalog catalog, GeoServerDataDirectory dd) {
        this.catalog = catalog;
        this.dd = dd;
    }

    protected abstract String getFeatureType(T var1);

    protected abstract String getWorkspace(T var1);

    protected abstract String getName(T var1);

    protected abstract String getExtension(T var1);

    protected abstract String getDir();

    protected abstract String getFileType();

    public Resource getResource(T info) {
        Resource resource;
        String featureType = this.getFeatureType(info);
        String workspace = this.getWorkspace(info);
        String name = this.getName(info);
        String extension = this.getExtension(info);
        if (featureType != null) {
            FeatureTypeInfo fti = this.catalog.getFeatureTypeByName(featureType);
            resource = this.dd.get((ResourceInfo)fti, new String[]{name + "." + extension});
        } else if (workspace != null) {
            WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspace);
            resource = this.dd.get(ws, new String[]{name + "." + extension});
        } else {
            resource = this.dd.get(new String[]{this.getDir(), name + "." + extension});
        }
        return resource;
    }

    public boolean delete(T info) {
        return this.getResource(info).delete();
    }

    public File getLocation(T info) {
        Resource resource;
        String featureType = this.getFeatureType(info);
        String workspace = this.getWorkspace(info);
        if (featureType != null) {
            FeatureTypeInfo fti = this.catalog.getFeatureTypeByName(featureType);
            resource = this.dd.get((ResourceInfo)fti, new String[0]);
        } else if (workspace != null) {
            WorkspaceInfo ws = this.catalog.getWorkspaceByName(workspace);
            resource = this.dd.get(ws, new String[0]);
        } else {
            resource = this.dd.get(new String[]{this.getDir()});
        }
        File destDir = resource.dir();
        if (!destDir.exists() || !destDir.isDirectory()) {
            destDir.mkdir();
        }
        return destDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(T info, String rawContent) {
        File destDir = this.getLocation(info);
        try {
            File file = new File(destDir, this.getName(info) + "." + this.getExtension(info));
            if (!file.exists()) {
                file.createNewFile();
            }
            FileManagerBase fileManagerBase = this;
            synchronized (fileManagerBase) {
                try (FileOutputStream fos = new FileOutputStream(file, false);){
                    fos.write(rawContent.getBytes());
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

