/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class TemplateInfo
implements Serializable,
Comparable<TemplateInfo> {
    private String identifier;
    private String description;
    protected String templateName;
    protected String workspace;
    protected String featureType;
    protected String extension;

    public TemplateInfo() {
        this.identifier = UUID.randomUUID().toString();
    }

    public TemplateInfo(String identifier, String templateName, String workspace, String featureType, String extension) {
        this.identifier = identifier;
        this.templateName = templateName;
        this.workspace = workspace;
        this.featureType = featureType;
        this.extension = extension;
    }

    public TemplateInfo(TemplateInfo info) {
        this(info.getIdentifier(), info.getTemplateName(), info.getWorkspace(), info.getFeatureType(), info.getExtension());
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getFullName() {
        Object fullName = "";
        if (this.workspace != null) {
            fullName = (String)fullName + this.workspace + ":";
        }
        if (this.featureType != null) {
            fullName = (String)fullName + this.featureType + ":";
        }
        fullName = (String)fullName + this.templateName;
        return fullName;
    }

    public boolean equals(Object info) {
        if (!super.equals(info)) {
            return false;
        }
        if (!this.lenientEquals(info)) {
            return false;
        }
        TemplateInfo templateInfo = (TemplateInfo)info;
        return Objects.equals(this.identifier, templateInfo.identifier) && Objects.equals(this.description, templateInfo.description);
    }

    public boolean lenientEquals(Object o) {
        if (o == null) {
            return false;
        }
        TemplateInfo that = (TemplateInfo)o;
        return Objects.equals(this.templateName, that.templateName) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.featureType, that.featureType) && Objects.equals(this.extension, that.extension);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.templateName, this.description, this.workspace, this.featureType, this.extension);
    }

    @Override
    public int compareTo(TemplateInfo o) {
        return this.templateName.compareTo(o.getTemplateName());
    }
}

