/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.TemplateInfo;
import org.geoserver.ows.Request;
import org.geoserver.util.XCQL;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cql2.CQLException;

@XmlRootElement(name="Rule")
public class TemplateRule
implements Serializable {
    private String ruleId;
    private Integer priority;
    private String templateIdentifier;
    private String templateName;
    private String outputFormat;
    private String service;
    private String cqlFilter;
    private String profileFilter;
    private boolean forceRule;

    public TemplateRule() {
        this.priority = 0;
        this.ruleId = UUID.randomUUID().toString();
    }

    public TemplateRule(TemplateRule rule) {
        this.ruleId = rule.ruleId == null ? UUID.randomUUID().toString() : rule.ruleId;
        this.priority = rule.priority;
        this.outputFormat = rule.outputFormat;
        this.cqlFilter = rule.cqlFilter;
        this.service = rule.service;
        this.forceRule = rule.forceRule;
        this.templateName = rule.templateName;
        this.templateIdentifier = rule.templateIdentifier;
        this.profileFilter = rule.profileFilter;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public boolean applyRule(Request request) {
        boolean result = true;
        if (this.outputFormat != null) {
            result = this.matchOutputFormatCommaSeparated(this.getOutputFormat(request));
        }
        if (result && this.cqlFilter != null) {
            result = this.evaluateCQLFilter(this.cqlFilter, request);
        }
        if (result && this.profileFilter != null) {
            result = this.evaluateCQLFilter(this.profileFilter, request);
        }
        return result;
    }

    private boolean matchOutputFormatCommaSeparated(String outputFormatExpression) {
        String[] outputFormats;
        if (StringUtils.isBlank((CharSequence)outputFormatExpression)) {
            return false;
        }
        for (String outputFormat : outputFormats = outputFormatExpression.split(",")) {
            if (!this.matchOutputFormat(outputFormat.trim())) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateCQLFilter(String filter, Request request) {
        return this.getCQLFilter(filter).evaluate((Object)request);
    }

    private Filter getCQLFilter(String filter) {
        try {
            return XCQL.toFilter((String)filter);
        }
        catch (CQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public SupportedFormat getOutputFormat() {
        if (this.outputFormat != null) {
            return SupportedFormat.valueOf(this.outputFormat);
        }
        return null;
    }

    public void setOutputFormat(SupportedFormat outputFormat) {
        this.outputFormat = outputFormat.name();
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getCqlFilter() {
        return this.cqlFilter;
    }

    public void setCqlFilter(String cqlFilter) {
        this.cqlFilter = cqlFilter;
    }

    public String getTemplateIdentifier() {
        return this.templateIdentifier;
    }

    public void setTemplateIdentifier(String templateIdentifier) {
        this.templateIdentifier = templateIdentifier;
    }

    private boolean matchOutputFormat(String outputFormat) {
        TemplateIdentifier identifier = TemplateIdentifier.fromOutputFormat(outputFormat);
        if (identifier == null) {
            return false;
        }
        String nameIdentifier = identifier.name();
        if (this.outputFormat.equals(SupportedFormat.GML.name())) {
            return nameIdentifier.startsWith(this.outputFormat);
        }
        if (this.outputFormat.equals(SupportedFormat.GEOJSON.name())) {
            return nameIdentifier.equals(TemplateIdentifier.GEOJSON.name()) || nameIdentifier.equals(TemplateIdentifier.JSON.name());
        }
        if (this.outputFormat.equals(SupportedFormat.HTML.name())) {
            return nameIdentifier.equals(TemplateIdentifier.HTML.name());
        }
        return nameIdentifier.equals(this.outputFormat);
    }

    public void setTemplateInfo(TemplateInfo templateInfo) {
        if (templateInfo != null) {
            this.templateName = templateInfo.getFullName();
            this.templateIdentifier = templateInfo.getIdentifier();
        }
    }

    public TemplateInfo getTemplateInfo() {
        TemplateInfo ti = new TemplateInfo();
        if (this.templateName != null && this.templateName.indexOf(":") != -1) {
            String[] nameSplit = this.templateName.split(":");
            if (nameSplit.length == 3) {
                ti.setWorkspace(nameSplit[0]);
                ti.setFeatureType(nameSplit[1]);
                ti.setTemplateName(nameSplit[2]);
            } else {
                ti.setWorkspace(nameSplit[0]);
                ti.setTemplateName(nameSplit[1]);
            }
        }
        ti.setIdentifier(this.templateIdentifier);
        return ti;
    }

    private String getOutputFormat(Request request) {
        String outputFormat = request.getOutputFormat();
        if (outputFormat == null) {
            String string = outputFormat = request.getKvp() != null ? (String)request.getKvp().get("f") : null;
        }
        if (outputFormat == null) {
            String string = outputFormat = request.getKvp() != null ? (String)request.getKvp().get("INFO_FORMAT") : null;
        }
        if (outputFormat == null) {
            outputFormat = request.getHttpRequest().getHeader("accept");
        }
        return outputFormat;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public boolean isForceRule() {
        return this.forceRule;
    }

    public void setForceRule(boolean forceRule) {
        this.forceRule = forceRule;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getProfileFilter() {
        return this.profileFilter;
    }

    public void setProfileFilter(String profileFilter) {
        this.profileFilter = profileFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateRule that = (TemplateRule)o;
        return Objects.equals(this.templateIdentifier, that.templateIdentifier) && Objects.equals(this.templateName, that.templateName) && Objects.equals(this.outputFormat, that.outputFormat) && Objects.equals(this.service, that.service) && Objects.equals(this.profileFilter, that.profileFilter) && Objects.equals(this.cqlFilter, that.cqlFilter) && Objects.equals(this.priority, that.priority);
    }

    public int hashCode() {
        return Objects.hash(this.templateIdentifier, this.templateName, this.outputFormat, this.service, this.cqlFilter, this.priority);
    }

    public static class TemplateRuleComparator
    implements Comparator<TemplateRule> {
        @Override
        public int compare(TemplateRule o1, TemplateRule o2) {
            int p2;
            int p1;
            int result = o1.isForceRule() ? -1 : (o2.isForceRule() ? 1 : ((p1 = o1.getPriority().intValue()) < (p2 = o2.getPriority().intValue()) ? -1 : (p2 < p1 ? 1 : 0)));
            return result;
        }
    }
}

