/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.configuration.schema.SchemaWatcher;
import org.geoserver.platform.FileWatcher;
import org.geoserver.platform.resource.Resource;
import org.geotools.util.logging.Logging;

public class SchemaDefinition {
    private Resource schemaDefinitionFile;
    private FileWatcher<String> watcher;
    private volatile String schemaContent;
    private static final Logger LOGGER = Logging.getLogger(SchemaDefinition.class);

    public SchemaDefinition(Resource schemaFile) {
        this.schemaDefinitionFile = schemaFile;
        this.watcher = new SchemaWatcher(this.schemaDefinitionFile);
        try {
            this.schemaContent = (String)this.watcher.read();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failure parsing " + this.schemaDefinitionFile, ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkSchema() {
        if (this.needsReload()) {
            LOGGER.log(Level.INFO, "Reloading json-ld schema for Feature Type {0}", this.schemaDefinitionFile.name());
            SchemaDefinition schemaDefinition = this;
            synchronized (schemaDefinition) {
                if (this.needsReload()) {
                    try {
                        this.schemaContent = (String)this.watcher.read();
                        return true;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
            }
        }
        return false;
    }

    private boolean needsReload() {
        return this.watcher != null && (this.watcher.isModified() || this.schemaContent != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadTemplate() {
        SchemaDefinition schemaDefinition = this;
        synchronized (schemaDefinition) {
            if (this.watcher != null) {
                try {
                    String root;
                    this.schemaContent = root = (String)this.watcher.read();
                }
                catch (IOException ioe) {
                    throw new RuntimeException(ioe);
                }
            }
        }
    }

    public String getSchemaContent() {
        return this.schemaContent;
    }
}

