/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import java.io.Serializable;
import java.util.Objects;
import java.util.UUID;

public class SchemaInfo
implements Serializable,
Comparable<SchemaInfo> {
    private String identifier;
    private String description;
    protected String schemaName;
    protected String workspace;
    protected String featureType;
    protected String extension;

    public SchemaInfo() {
        this.identifier = UUID.randomUUID().toString();
    }

    public SchemaInfo(String identifier, String schemaName, String workspace, String featureType, String extension) {
        this.identifier = identifier;
        this.schemaName = schemaName;
        this.workspace = workspace;
        this.featureType = featureType;
        this.extension = extension;
    }

    public SchemaInfo(SchemaInfo info) {
        this(info.getIdentifier(), info.getSchemaName(), info.getWorkspace(), info.getFeatureType(), info.getExtension());
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public void setWorkspace(String workspace) {
        this.workspace = workspace;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtension() {
        return this.extension;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public String getFullName() {
        Object fullName = "";
        if (this.workspace != null) {
            fullName = (String)fullName + this.workspace + ":";
        }
        if (this.featureType != null) {
            fullName = (String)fullName + this.featureType + ":";
        }
        fullName = (String)fullName + this.schemaName;
        return fullName;
    }

    public boolean equals(Object info) {
        if (!super.equals(info)) {
            return false;
        }
        if (!this.lenientEquals(info)) {
            return false;
        }
        SchemaInfo templateInfo = (SchemaInfo)info;
        return Objects.equals(this.identifier, templateInfo.identifier) && Objects.equals(this.description, templateInfo.description);
    }

    public boolean lenientEquals(Object o) {
        if (o == null) {
            return false;
        }
        SchemaInfo that = (SchemaInfo)o;
        return Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.workspace, that.workspace) && Objects.equals(this.featureType, that.featureType) && Objects.equals(this.extension, that.extension);
    }

    public int hashCode() {
        return Objects.hash(this.identifier, this.schemaName, this.description, this.workspace, this.featureType, this.extension);
    }

    @Override
    public int compareTo(SchemaInfo o) {
        return this.schemaName.compareTo(o.getSchemaName());
    }
}

