/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogBeforeAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.featurestemplating.configuration.schema.SchemaDAOListener;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAO;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoEvent;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geoserver.security.PropertyFileWatcher;

public class SchemaInfoDAOImpl
implements SchemaInfoDAO {
    private SortedSet<SchemaInfo> schemaDataSet;
    private PropertyFileWatcher fileWatcher;
    private GeoServerDataDirectory dd;
    private Set<SchemaDAOListener> listeners;
    private static final String PROPERTY_FILE_NAME = "schema-data.properties";

    public SchemaInfoDAOImpl(GeoServerDataDirectory dd) {
        this.dd = dd;
        Resource schemaDir = dd.get(new String[]{"features-templating/schemas"});
        File dir = schemaDir.dir();
        if (!dir.exists()) {
            dir.mkdir();
        }
        Resource prop = dd.get(new String[]{"features-templating/schemas", PROPERTY_FILE_NAME});
        prop.file();
        this.fileWatcher = new PropertyFileWatcher(prop);
        this.schemaDataSet = Collections.synchronizedSortedSet(new TreeSet());
        this.listeners = new HashSet<SchemaDAOListener>();
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        catalog.addListener((CatalogListener)new CatalogListenerSchemaInfo());
    }

    @Override
    public List<SchemaInfo> findAll() {
        this.reloadIfNeeded();
        return new ArrayList<SchemaInfo>(this.schemaDataSet);
    }

    @Override
    public SchemaInfo saveOrUpdate(SchemaInfo schemaData) {
        this.reloadIfNeeded();
        boolean isUpdate = this.schemaDataSet.stream().anyMatch(ti -> ti.getIdentifier().equals(schemaData.getIdentifier()));
        if (isUpdate) {
            this.fireSchemaUpdateEvent(schemaData);
            this.schemaDataSet.removeIf(ti -> ti.getIdentifier().equals(schemaData.getIdentifier()));
        }
        this.schemaDataSet.add(schemaData);
        this.storeProperties();
        return schemaData;
    }

    @Override
    public void delete(SchemaInfo schemaData) {
        this.reloadIfNeeded();
        this.schemaDataSet.remove(schemaData);
        this.fireSchemaInfoRemoveEvent(schemaData);
        this.storeProperties();
    }

    @Override
    public void delete(List<SchemaInfo> schemaInfos) {
        this.reloadIfNeeded();
        this.schemaDataSet.removeAll(schemaInfos);
        this.storeProperties();
        for (SchemaInfo ti : schemaInfos) {
            this.fireSchemaInfoRemoveEvent(ti);
        }
    }

    @Override
    public void deleteAll() {
        this.reloadIfNeeded();
        SortedSet<SchemaInfo> schemaInfos = this.schemaDataSet;
        this.schemaDataSet = Collections.synchronizedSortedSet(new TreeSet());
        this.storeProperties();
        for (SchemaInfo ti : schemaInfos) {
            this.fireSchemaInfoRemoveEvent(ti);
        }
    }

    @Override
    public SchemaInfo findById(String id) {
        this.reloadIfNeeded();
        Optional<SchemaInfo> optional = this.schemaDataSet.stream().filter(ti -> ti.getIdentifier().equals(id)).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        return null;
    }

    @Override
    public SchemaInfo findByFullName(String fullName) {
        this.reloadIfNeeded();
        Optional<SchemaInfo> SchemaInfo2 = this.schemaDataSet.stream().filter(ti -> ti.getFullName().equals(fullName)).findFirst();
        if (SchemaInfo2.isPresent()) {
            return SchemaInfo2.get();
        }
        return null;
    }

    @Override
    public List<SchemaInfo> findByFeatureTypeInfo(FeatureTypeInfo featureTypeInfo) {
        this.reloadIfNeeded();
        String workspace = featureTypeInfo.getStore().getWorkspace().getName();
        String name = featureTypeInfo.getName();
        return this.schemaDataSet.stream().filter(ti -> ti.getWorkspace() == null && ti.getFeatureType() == null || ti.getFeatureType() == null && ti.getWorkspace().equals(workspace) || ti.getWorkspace().equals(workspace) && ti.getFeatureType().equals(name)).collect(Collectors.toList());
    }

    private void fireSchemaUpdateEvent(SchemaInfo schemaInfo) {
        for (SchemaDAOListener listener : this.listeners) {
            listener.handleUpdateEvent(new SchemaInfoEvent(schemaInfo));
        }
    }

    private void fireSchemaInfoRemoveEvent(SchemaInfo SchemaInfo2) {
        for (SchemaDAOListener listener : this.listeners) {
            listener.handleDeleteEvent(new SchemaInfoEvent(SchemaInfo2));
        }
    }

    @Override
    public void addSchemaListener(SchemaDAOListener listener) {
        this.listeners.add(listener);
    }

    private SchemaInfo parseProperty(String key, String value) {
        String[] values;
        SchemaInfo schemaData = new SchemaInfo();
        schemaData.setIdentifier(key);
        for (String v : values = value.split(";")) {
            String[] attribute = v.split("=");
            String attrName = attribute[0];
            String attrValue = attribute[1];
            if (attrName.equals("schemaName")) {
                schemaData.setSchemaName(attrValue);
                continue;
            }
            if (attrName.equals("extension")) {
                schemaData.setExtension(attrValue);
                continue;
            }
            if (attrName.equals("workspace")) {
                schemaData.setWorkspace(attrValue);
                continue;
            }
            if (!attrName.equals("featureTypeInfo")) continue;
            schemaData.setFeatureType(attrValue);
        }
        schemaData.setIdentifier(key);
        return schemaData;
    }

    private Properties toProperties() {
        Properties properties = new Properties();
        for (SchemaInfo td : this.schemaDataSet) {
            String fti;
            StringBuilder sb = new StringBuilder();
            sb.append("schemaName=").append(td.getSchemaName()).append(";extension=").append(td.getExtension());
            String ws = td.getWorkspace();
            if (ws != null) {
                sb.append(";workspace=").append(td.getWorkspace());
            }
            if ((fti = td.getFeatureType()) != null) {
                sb.append(";featureTypeInfo=").append(td.getFeatureType());
            }
            properties.put(td.getIdentifier(), sb.toString());
        }
        return properties;
    }

    public void storeProperties() {
        Properties p = this.toProperties();
        Resource propFile = this.dd.get(new String[]{"features-templating/schemas", PROPERTY_FILE_NAME});
        try (OutputStream os = propFile.out();){
            p.store(os, null);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not write rules to schema-data.properties");
        }
    }

    private boolean isModified() {
        return this.fileWatcher != null && this.fileWatcher.isStale();
    }

    private void loadSchemaInfo() {
        try {
            Properties properties = this.fileWatcher.getProperties();
            this.schemaDataSet = Collections.synchronizedSortedSet(new TreeSet());
            for (Object k : properties.keySet()) {
                SchemaInfo td = this.parseProperty(k.toString(), properties.getProperty(k.toString()));
                this.schemaDataSet.add(td);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void reloadIfNeeded() {
        if (this.isModified() || this.schemaDataSet.isEmpty()) {
            this.loadSchemaInfo();
        }
    }

    public static class CatalogListenerSchemaInfo
    implements CatalogListener {
        public void handlePreAddEvent(CatalogBeforeAddEvent event) throws CatalogException {
        }

        public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
            CatalogInfo source = event.getSource();
            if (source instanceof FeatureTypeInfo) {
                this.removeFtTemplates((FeatureTypeInfo)source);
            } else if (source instanceof WorkspaceInfo) {
                this.removeWSTemplates((WorkspaceInfo)source);
            }
        }

        private void removeFtTemplates(FeatureTypeInfo ft) {
            SchemaInfoDAOImpl dao = SchemaInfoDAO.get();
            List<SchemaInfo> SchemaInfos = dao.findByFeatureTypeInfo(ft);
            dao.delete(SchemaInfos.stream().filter(ti -> ti.getFeatureType() != null).collect(Collectors.toList()));
        }

        private void removeWSTemplates(WorkspaceInfo ws) {
            SchemaInfoDAOImpl dao = SchemaInfoDAO.get();
            List<SchemaInfo> SchemaInfos = dao.findAll().stream().filter(ti -> ti.getWorkspace().equals(ws.getName())).collect(Collectors.toList());
            dao.delete(SchemaInfos);
        }

        public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
            int nameIdx;
            CatalogInfo source = event.getSource();
            if (source instanceof FeatureTypeInfo) {
                int nameIdx2 = event.getPropertyNames().indexOf("name");
                if (nameIdx2 != -1) {
                    String newName = (String)event.getNewValues().get(nameIdx2);
                    this.updateSchemaInfoLayerName((FeatureTypeInfo)source, newName);
                }
            } else if (source instanceof WorkspaceInfo && (nameIdx = event.getPropertyNames().indexOf("name")) != -1) {
                String oldName = (String)event.getOldValues().get(nameIdx);
                String newName = (String)event.getNewValues().get(nameIdx);
                this.updateWorkspaceNames(oldName, newName);
            }
        }

        private void updateSchemaInfoLayerName(FeatureTypeInfo fti, String newName) {
            SchemaInfoDAOImpl dao = SchemaInfoDAO.get();
            List<SchemaInfo> SchemaInfo2 = dao.findByFeatureTypeInfo(fti);
            for (SchemaInfo ti : SchemaInfo2) {
                ti.setFeatureType(newName);
            }
            dao.storeProperties();
        }

        private void updateSchemaInfoWorkspace(WorkspaceInfo wi, FeatureTypeInfo fti) {
            SchemaInfoDAOImpl dao = SchemaInfoDAO.get();
            List<SchemaInfo> SchemaInfo2 = dao.findByFeatureTypeInfo(fti);
            for (SchemaInfo ti : SchemaInfo2) {
                ti.setWorkspace(wi.getName());
            }
            dao.storeProperties();
        }

        private void updateWorkspaceNames(String oldName, String newName) {
            SchemaInfoDAOImpl dao = SchemaInfoDAO.get();
            List<SchemaInfo> infos = dao.findAll();
            for (SchemaInfo ti : infos) {
                if (!ti.getWorkspace().equals(oldName)) continue;
                ti.setWorkspace(newName);
            }
            dao.storeProperties();
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
            CatalogInfo source = event.getSource();
            if (source instanceof FeatureTypeInfo) {
                FeatureTypeInfo info = (FeatureTypeInfo)source;
                int wsIdx = event.getPropertyNames().indexOf("workspace");
                if (wsIdx != -1) {
                    WorkspaceInfo newWorkspace = (WorkspaceInfo)event.getNewValues().get(wsIdx);
                    this.updateSchemaInfoWorkspace(newWorkspace, info);
                }
            }
        }

        public void reloaded() {
        }
    }
}

