/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServerDataDirectory;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.visitors.SimplifiedPropertyReplacer;
import org.geoserver.featurestemplating.configuration.AbstractLoader;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.schema.SchemaDefinition;
import org.geoserver.featurestemplating.configuration.schema.SchemaFileManager;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAO;
import org.geoserver.featurestemplating.configuration.schema.SchemaRule;
import org.geoserver.featurestemplating.configuration.schema.SchemaRuleService;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.resource.Resource;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.data.complex.AppSchemaDataAccessRegistry;
import org.geotools.data.complex.DataAccessRegistry;
import org.geotools.data.complex.FeatureTypeMapping;
import org.geotools.data.complex.feature.type.ComplexFeatureTypeImpl;
import org.xml.sax.helpers.NamespaceSupport;

public class SchemaLoader
extends AbstractLoader {
    private final LoadingCache<AbstractLoader.CacheKey, SchemaDefinition> schemaCache = CacheBuilder.newBuilder().maximumSize(100L).initialCapacity(1).expireAfterAccess(120L, TimeUnit.MINUTES).build((CacheLoader)new SchemaCacheLoader());

    public SchemaLoader(GeoServerDataDirectory dd) {
        super(dd);
    }

    public String getSchema(FeatureTypeInfo typeInfo, String outputFormat, Request request) throws ExecutionException {
        String schemaIdentifier;
        String string = schemaIdentifier = request == null ? this.evaluatesTemplateRule(typeInfo) : this.evaluatesTemplateRule(typeInfo, request);
        if (schemaIdentifier == null) {
            schemaIdentifier = TemplateIdentifier.fromOutputFormat(outputFormat).getFilename();
        }
        return this.getSchemaByIdentifier(typeInfo, schemaIdentifier);
    }

    public String getSchema(FeatureTypeInfo typeInfo, String outputFormat) throws ExecutionException {
        return this.getSchema(typeInfo, outputFormat, null);
    }

    private String getSchemaByIdentifier(FeatureTypeInfo typeInfo, String templateIdentifier) throws ExecutionException {
        AbstractLoader.CacheKey key = new AbstractLoader.CacheKey(this, typeInfo, templateIdentifier);
        SchemaDefinition schemaDefinition = (SchemaDefinition)this.schemaCache.get((Object)key);
        boolean updateCache = false;
        if (schemaDefinition.checkSchema()) {
            updateCache = true;
        }
        String root = schemaDefinition.getSchemaContent();
        if (updateCache) {
            this.schemaCache.put((Object)key, (Object)schemaDefinition);
        }
        return root;
    }

    private NamespaceSupport declareNamespaces(FeatureType type) {
        Map namespaces;
        NamespaceSupport namespaceSupport = null;
        if (type instanceof ComplexFeatureTypeImpl && (namespaces = (Map)type.getUserData().get("declaredNamespacesMap")) != null) {
            namespaceSupport = new NamespaceSupport();
            for (Map.Entry entry : namespaces.entrySet()) {
                String prefix = (String)entry.getKey();
                String namespace = (String)entry.getValue();
                namespaceSupport.declarePrefix(prefix, namespace);
            }
        }
        return namespaceSupport;
    }

    private void replaceSimplifiedPropertiesIfNeeded(FeatureTypeInfo featureTypeInfo, RootBuilder rootBuilder) {
        try {
            DataAccessRegistry registry;
            FeatureTypeMapping featureTypeMapping;
            if (featureTypeInfo.getFeatureType() instanceof ComplexFeatureTypeImpl && rootBuilder != null && (featureTypeMapping = (registry = AppSchemaDataAccessRegistry.getInstance()).mappingByElement(featureTypeInfo.getQualifiedNativeName())) != null) {
                SimplifiedPropertyReplacer visitor = new SimplifiedPropertyReplacer(featureTypeMapping);
                rootBuilder.accept(visitor, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private String evaluatesTemplateRule(FeatureTypeInfo featureTypeInfo) {
        return this.evaluatesTemplateRule(featureTypeInfo, (Request)Dispatcher.REQUEST.get());
    }

    private String evaluatesTemplateRule(FeatureTypeInfo featureTypeInfo, Request request) {
        int size;
        ArrayList<SchemaRule> matching = new ArrayList<SchemaRule>();
        SchemaRuleService ruleService = new SchemaRuleService(featureTypeInfo);
        Set<SchemaRule> rules = ruleService.getRules();
        String result = null;
        if (rules != null && !rules.isEmpty()) {
            for (SchemaRule r : rules) {
                if (!r.applyRule(request)) continue;
                matching.add(r);
            }
        }
        if ((size = matching.size()) > 0) {
            result = this.getHighestPriorityIdentifier(matching);
        }
        return result;
    }

    private String getHighestPriorityIdentifier(List<SchemaRule> rules) {
        if (rules.size() > 1) {
            SchemaRule.SchemaRuleComparator comparator = new SchemaRule.SchemaRuleComparator();
            rules.sort(comparator);
        }
        return rules.get(0).getSchemaIdentifier();
    }

    public void cleanCache(FeatureTypeInfo fti, String templateIdentifier) {
        AbstractLoader.CacheKey key = new AbstractLoader.CacheKey(this, fti, templateIdentifier);
        if (this.schemaCache.getIfPresent((Object)key) != null) {
            this.schemaCache.invalidate((Object)key);
        }
    }

    public void removeAllWithIdentifier(String templateIdentifier) {
        Set keys = this.schemaCache.asMap().keySet();
        for (AbstractLoader.CacheKey key : keys) {
            if (!key.getIdentifier().equals(templateIdentifier)) continue;
            this.schemaCache.invalidate((Object)key);
        }
    }

    private SchemaFileManager getSchemaFileManager() {
        return SchemaFileManager.get();
    }

    public void reset() {
        this.schemaCache.invalidateAll();
    }

    public static SchemaLoader get() {
        return (SchemaLoader)GeoServerExtensions.bean(SchemaLoader.class);
    }

    private class SchemaCacheLoader
    extends CacheLoader<AbstractLoader.CacheKey, SchemaDefinition> {
        private SchemaCacheLoader() {
        }

        public SchemaDefinition load(AbstractLoader.CacheKey key) {
            NamespaceSupport namespaces = null;
            try {
                FeatureType type = key.getResource().getFeatureType();
                namespaces = SchemaLoader.this.declareNamespaces(type);
            }
            catch (IOException e) {
                throw new RuntimeException("Error retrieving FeatureType " + key.getResource().getName() + "Exception is: " + e.getMessage());
            }
            SchemaInfo schemaInfo = SchemaInfoDAO.get().findById(key.getIdentifier());
            Resource resource = schemaInfo != null ? SchemaLoader.this.getSchemaFileManager().getSchemaResource(schemaInfo) : SchemaLoader.this.getDataDirectory().get((ResourceInfo)key.getResource(), new String[]{key.getIdentifier()});
            SchemaDefinition schemaDefinition = new SchemaDefinition(resource);
            return schemaDefinition;
        }
    }
}

