/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import java.io.Serializable;
import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import javax.xml.bind.annotation.XmlRootElement;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.configuration.TemplateIdentifier;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.ows.Request;
import org.geoserver.util.XCQL;
import org.geotools.api.filter.Filter;
import org.geotools.filter.text.cql2.CQLException;

@XmlRootElement(name="Rule")
public class SchemaRule
implements Serializable {
    private String ruleId;
    private Integer priority;
    private String schemaIdentifier;
    private String schemaName;
    private String outputFormat;
    private String service;
    private String cqlFilter;
    private String profileFilter;
    private boolean forceRule;

    public SchemaRule() {
        this.priority = 0;
        this.ruleId = UUID.randomUUID().toString();
    }

    public SchemaRule(SchemaRule rule) {
        this.ruleId = rule.ruleId == null ? UUID.randomUUID().toString() : rule.ruleId;
        this.priority = rule.priority;
        this.outputFormat = rule.outputFormat;
        this.cqlFilter = rule.cqlFilter;
        this.service = rule.service;
        this.forceRule = rule.forceRule;
        this.schemaName = rule.schemaName;
        this.schemaIdentifier = rule.schemaIdentifier;
        this.profileFilter = rule.profileFilter;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public boolean applyRule(Request request) {
        boolean result = true;
        if (this.outputFormat != null) {
            result = this.matchOutputFormat(this.getOutputFormat(request));
        }
        if (result && this.cqlFilter != null) {
            result = this.evaluateCQLFilter(this.cqlFilter, request);
        }
        if (result && this.profileFilter != null) {
            result = this.evaluateCQLFilter(this.profileFilter, request);
        }
        return result;
    }

    private boolean evaluateCQLFilter(String filter, Request request) {
        return this.getCQLFilter(filter).evaluate((Object)request);
    }

    private Filter getCQLFilter(String filter) {
        try {
            return XCQL.toFilter((String)filter);
        }
        catch (CQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public SupportedFormat getOutputFormat() {
        if (this.outputFormat != null) {
            return SupportedFormat.valueOf(this.outputFormat);
        }
        return null;
    }

    public void setOutputFormat(SupportedFormat outputFormat) {
        this.outputFormat = outputFormat.name();
    }

    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    public String getCqlFilter() {
        return this.cqlFilter;
    }

    public void setCqlFilter(String cqlFilter) {
        this.cqlFilter = cqlFilter;
    }

    public String getSchemaIdentifier() {
        return this.schemaIdentifier;
    }

    public void setSchemaIdentifier(String schemaIdentifier) {
        this.schemaIdentifier = schemaIdentifier;
    }

    private boolean matchOutputFormat(String outputFormat) {
        TemplateIdentifier identifier = TemplateIdentifier.fromOutputFormat(outputFormat);
        if (identifier == null) {
            return false;
        }
        String nameIdentifier = identifier.name();
        if (this.outputFormat.equals(SupportedFormat.GML.name())) {
            return nameIdentifier.startsWith(this.outputFormat);
        }
        if (this.outputFormat.equals(SupportedFormat.GEOJSON.name())) {
            return nameIdentifier.equals(TemplateIdentifier.GEOJSON.name()) || nameIdentifier.equals(TemplateIdentifier.JSON.name());
        }
        if (this.outputFormat.equals(SupportedFormat.HTML.name())) {
            return nameIdentifier.equals(TemplateIdentifier.HTML.name());
        }
        return nameIdentifier.equals(this.outputFormat);
    }

    public void setSchemaInfo(SchemaInfo schemaInfo) {
        if (schemaInfo != null) {
            this.schemaName = schemaInfo.getFullName();
            this.schemaIdentifier = schemaInfo.getIdentifier();
        }
    }

    public SchemaInfo getSchemaInfo() {
        SchemaInfo ti = new SchemaInfo();
        if (this.schemaName != null && this.schemaName.indexOf(":") != -1) {
            String[] nameSplit = this.schemaName.split(":");
            if (nameSplit.length == 3) {
                ti.setWorkspace(nameSplit[0]);
                ti.setFeatureType(nameSplit[1]);
                ti.setSchemaName(nameSplit[2]);
            } else {
                ti.setWorkspace(nameSplit[0]);
                ti.setSchemaName(nameSplit[1]);
            }
        }
        ti.setIdentifier(this.schemaIdentifier);
        return ti;
    }

    private String getOutputFormat(Request request) {
        String outputFormat = request.getOutputFormat();
        if (outputFormat == null) {
            String string = outputFormat = request.getKvp() != null ? (String)request.getKvp().get("f") : null;
        }
        if (outputFormat == null) {
            outputFormat = request.getKvp() != null ? (String)request.getKvp().get("INFO_FORMAT") : null;
        }
        return outputFormat;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public boolean isForceRule() {
        return this.forceRule;
    }

    public void setForceRule(boolean forceRule) {
        this.forceRule = forceRule;
    }

    public Integer getPriority() {
        return this.priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String getProfileFilter() {
        return this.profileFilter;
    }

    public void setProfileFilter(String profileFilter) {
        this.profileFilter = profileFilter;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRule that = (SchemaRule)o;
        return Objects.equals(this.schemaIdentifier, that.schemaIdentifier) && Objects.equals(this.schemaName, that.schemaName) && Objects.equals(this.outputFormat, that.outputFormat) && Objects.equals(this.service, that.service) && Objects.equals(this.profileFilter, that.profileFilter) && Objects.equals(this.cqlFilter, that.cqlFilter) && Objects.equals(this.priority, that.priority);
    }

    public int hashCode() {
        return Objects.hash(this.schemaIdentifier, this.schemaName, this.outputFormat, this.service, this.priority);
    }

    public static class SchemaRuleComparator
    implements Comparator<SchemaRule> {
        @Override
        public int compare(SchemaRule o1, SchemaRule o2) {
            int p2;
            int p1;
            int result = o1.isForceRule() ? -1 : (o2.isForceRule() ? 1 : ((p1 = o1.getPriority().intValue()) < (p2 = o2.getPriority().intValue()) ? -1 : (p2 < p1 ? 1 : 0)));
            return result;
        }
    }
}

