/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaLayerConfig;
import org.geoserver.featurestemplating.configuration.schema.SchemaRule;
import org.geoserver.platform.GeoServerExtensions;

public class SchemaRuleService {
    private FeatureTypeInfo featureTypeInfo;

    public SchemaRuleService(FeatureTypeInfo featureTypeInfo) {
        this.featureTypeInfo = featureTypeInfo;
    }

    public boolean removeRule(String ruleId) {
        boolean result = false;
        Set<SchemaRule> rules = this.getRules();
        if (rules != null && !rules.isEmpty() && (result = rules.removeIf(r -> r.getRuleId().equals(ruleId)))) {
            SchemaLayerConfig config = this.getSchemaLayerConfig();
            config.setSchemaRules(rules);
            this.featureTypeInfo.getMetadata().put("FEATURES_SCHEMA_LAYER_CONF", (Serializable)config);
            this.getCatalog().save((ResourceInfo)this.featureTypeInfo);
        }
        return result;
    }

    public void replaceRule(SchemaRule rule) {
        Set<SchemaRule> rules = this.getRules();
        if (rules != null && rules.removeIf(r -> r.getRuleId().equals(rule.getRuleId()))) {
            Set<SchemaRule> ruleset = SchemaRuleService.updatePriorities(new ArrayList<SchemaRule>(rules), rule);
            SchemaLayerConfig config = this.getSchemaLayerConfig();
            config.setSchemaRules(ruleset);
            this.featureTypeInfo.getMetadata().put("FEATURES_SCHEMA_LAYER_CONF", (Serializable)config);
            this.getCatalog().save((ResourceInfo)this.featureTypeInfo);
        }
    }

    public void saveRule(SchemaRule rule) {
        SchemaLayerConfig config = this.getSchemaLayerConfig();
        if (config == null) {
            config = new SchemaLayerConfig();
        }
        Set<SchemaRule> rules = config.getSchemaRules();
        Set<SchemaRule> ruleset = SchemaRuleService.updatePriorities(new ArrayList<SchemaRule>(rules), rule);
        config.setSchemaRules(ruleset);
        this.featureTypeInfo.getMetadata().put("FEATURES_SCHEMA_LAYER_CONF", (Serializable)config);
        this.getCatalog().save((ResourceInfo)this.featureTypeInfo);
    }

    private SchemaLayerConfig getSchemaLayerConfig() {
        return (SchemaLayerConfig)this.featureTypeInfo.getMetadata().get("FEATURES_SCHEMA_LAYER_CONF", SchemaLayerConfig.class);
    }

    public Set<SchemaRule> getRules() {
        SchemaLayerConfig layerConfig = this.getSchemaLayerConfig();
        if (layerConfig != null) {
            return layerConfig.getSchemaRules();
        }
        return Collections.emptySet();
    }

    public SchemaRule getRule(String ruleId) {
        Optional<SchemaRule> opRule;
        Set<SchemaRule> rules = this.getRules();
        if (rules != null && !rules.isEmpty() && (opRule = rules.stream().filter(r -> r.getRuleId().equals(ruleId)).findFirst()).isPresent()) {
            return opRule.get();
        }
        return null;
    }

    private Catalog getCatalog() {
        return (Catalog)GeoServerExtensions.bean((String)"catalog");
    }

    public static Set<SchemaRule> updatePriorities(List<SchemaRule> rules, SchemaRule newRule) {
        HashSet<SchemaRule> set = new HashSet<SchemaRule>(rules.size());
        int updatedPriority = newRule.getPriority();
        boolean newRuleAdded = false;
        for (SchemaRule rule : rules) {
            boolean isUpdating = rule.getRuleId().equals(newRule.getRuleId());
            int priority = rule.getPriority();
            if (priority == updatedPriority) {
                if (!newRuleAdded) {
                    set.add(newRule);
                    newRuleAdded = true;
                }
                ++priority;
                if (!isUpdating) {
                    rule.setPriority(priority);
                    updatedPriority = priority;
                }
            }
            if (isUpdating) continue;
            set.add(rule);
        }
        if (set.isEmpty() || !newRuleAdded) {
            set.add(newRule);
        }
        return set;
    }
}

