/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import org.geoserver.featurestemplating.configuration.schema.SchemaFileManager;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoDAO;
import org.geoserver.featurestemplating.configuration.schema.SchemaLoader;

public class SchemaService {
    private SchemaLoader loader = SchemaLoader.get();
    private SchemaFileManager schemaFileManager = SchemaFileManager.get();
    private SchemaInfoDAO schemaInfoDAO = SchemaInfoDAO.get();

    public void saveOrUpdate(SchemaInfo schemaInfo, String rawTemplate) {
        this.schemaFileManager.saveSchemaFile(schemaInfo, rawTemplate);
        SchemaInfo current = this.schemaInfoDAO.findById(schemaInfo.getIdentifier());
        if (current != null && !current.getFullName().equals(schemaInfo.getFullName()) && this.schemaFileManager.delete(current)) {
            this.loader.removeAllWithIdentifier(schemaInfo.getIdentifier());
        }
        this.schemaInfoDAO.saveOrUpdate(schemaInfo);
    }

    public void delete(SchemaInfo schemaInfo) {
        this.schemaFileManager.delete(schemaInfo);
        this.loader.removeAllWithIdentifier(schemaInfo.getIdentifier());
        this.schemaInfoDAO.delete(schemaInfo);
    }
}

