/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaDAOListener;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfo;
import org.geoserver.featurestemplating.configuration.schema.SchemaInfoEvent;
import org.geoserver.featurestemplating.configuration.schema.SchemaLayerConfig;
import org.geoserver.featurestemplating.configuration.schema.SchemaLoader;
import org.geoserver.featurestemplating.configuration.schema.SchemaRule;
import org.geoserver.platform.GeoServerExtensions;

public class SchemaTypeTemplateDAOListener
implements SchemaDAOListener {
    private FeatureTypeInfo fti;

    public SchemaTypeTemplateDAOListener(FeatureTypeInfo featureTypeInfo) {
        this.fti = featureTypeInfo;
    }

    @Override
    public void handleDeleteEvent(SchemaInfoEvent deleteEvent) {
        Set<SchemaRule> rules;
        SchemaLayerConfig layerConfig = (SchemaLayerConfig)this.fti.getMetadata().get("FEATURES_SCHEMA_LAYER_CONF", SchemaLayerConfig.class);
        SchemaInfo ti = deleteEvent.getSource();
        if (layerConfig != null && !(rules = layerConfig.getSchemaRules()).isEmpty() && rules.removeIf(r -> r.getSchemaIdentifier().equals(deleteEvent.getSource().getIdentifier()))) {
            this.fti.getMetadata().put("FEATURES_SCHEMA_LAYER_CONF", (Serializable)layerConfig);
            this.saveFeatureTypeInfo();
            this.updateCache(ti);
        }
    }

    @Override
    public void handleUpdateEvent(SchemaInfoEvent updateEvent) {
        Set<SchemaRule> rules;
        SchemaLayerConfig layerConfig = (SchemaLayerConfig)this.fti.getMetadata().get("FEATURES_SCHEMA_LAYER_CONF", SchemaLayerConfig.class);
        if (layerConfig != null && !(rules = layerConfig.getSchemaRules()).isEmpty()) {
            SchemaInfo info = updateEvent.getSource();
            Optional<SchemaRule> rule = rules.stream().filter(r -> r.getSchemaIdentifier().equals(info.getIdentifier())).findFirst();
            if (rule.isPresent()) {
                SchemaRule r2 = rule.get();
                if (!r2.getSchemaName().equals(info.getFullName())) {
                    r2.setSchemaName(info.getFullName());
                }
                this.updateCache(info);
                rules.removeIf(tr -> tr.getSchemaIdentifier().equals(info.getIdentifier()));
                rules.add(r2);
                layerConfig.setSchemaRules(rules);
                this.fti.getMetadata().put("FEATURES_SCHEMA_LAYER_CONF", (Serializable)layerConfig);
                this.saveFeatureTypeInfo();
            }
        }
    }

    private void saveFeatureTypeInfo() {
        Catalog catalog = (Catalog)GeoServerExtensions.bean((String)"catalog");
        catalog.save((ResourceInfo)this.fti);
    }

    private void updateCache(SchemaInfo info) {
        SchemaLoader loader = SchemaLoader.get();
        loader.cleanCache(this.fti, info.getIdentifier());
    }
}

