/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.configuration.schema;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.geoserver.platform.FileWatcher;
import org.geoserver.platform.resource.Resource;

public class SchemaWatcher
extends FileWatcher<String> {
    public SchemaWatcher(Resource resource) {
        super(resource);
    }

    public String read() throws IOException {
        String result = null;
        if (this.resource.getType() == Resource.Type.RESOURCE) {
            try (InputStream is = this.resource.in();){
                result = this.parseResource(this.resource);
                this.lastModified = this.resource.lastmodified();
                this.lastCheck = System.currentTimeMillis();
                this.stale = false;
            }
        }
        return result;
    }

    public String parseResource(Resource resource) throws IOException {
        String content = new String(resource.getContents(), StandardCharsets.UTF_8);
        return content;
    }
}

