/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions;

import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.parameter.Parameter;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.operation.MathTransform;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.geotools.referencing.factory.epsg.CartesianAuthorityFactory;
import org.locationtech.jts.geom.Geometry;

public class ReprojectFunction
extends FunctionExpressionImpl {
    public static FunctionName NAME = new FunctionNameImpl("reproject", FunctionNameImpl.parameter((String)"reprojected", Geometry.class), new Parameter[]{FunctionNameImpl.parameter((String)"targetCRS", String.class), FunctionNameImpl.parameter((String)"geometry", Geometry.class)});

    public ReprojectFunction() {
        super(NAME);
    }

    public Object evaluate(Object feature) {
        Object sourceCRS;
        Geometry arg1;
        CoordinateReferenceSystem targetCRS;
        try {
            targetCRS = (CoordinateReferenceSystem)this.getExpression(0).evaluate(feature, CoordinateReferenceSystem.class);
            if (targetCRS == null) {
                String strCrs = (String)this.getExpression(0).evaluate(feature, String.class);
                try {
                    targetCRS = CRS.decode((String)strCrs);
                }
                catch (FactoryException e) {
                    targetCRS = CRS.parseWKT((String)strCrs);
                }
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Expected argument of type CoordinateReferenceSystem, WKT or valid EPSG code for argument #0");
        }
        try {
            arg1 = (Geometry)this.getExpression(1).evaluate(feature, Geometry.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Filter Function problem for function reproject argument #1 - expected type Geometry");
        }
        try {
            sourceCRS = arg1.getSRID() != 0 ? CRS.decode((String)("EPSG:" + arg1.getSRID())) : CartesianAuthorityFactory.GENERIC_2D;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to retrieve source CRS");
        }
        try {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            return JTS.transform((Geometry)arg1, (MathTransform)transform);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to transform geometry");
        }
    }
}

