/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.ows.util.ResponseUtils;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.parameter.Parameter;
import org.geotools.filter.FunctionImpl;
import org.geotools.filter.capability.FunctionNameImpl;

public class ServiceLinkFunction
extends FunctionImpl {
    public static FunctionName NAME = new FunctionNameImpl("serviceLink", String.class, new Parameter[]{FunctionNameImpl.parameter((String)"template", String.class), FunctionNameImpl.parameter((String)"param", Object.class, (int)0, (int)Integer.MAX_VALUE)});

    public ServiceLinkFunction() {
        this.functionName = NAME;
    }

    public Object evaluate(Object feature) {
        List params = this.getParameters();
        String template = (String)((Expression)params.get(0)).evaluate(feature, String.class);
        if (template == null) {
            return null;
        }
        Object[] templateParameters = params.stream().skip(1L).map(p -> (String)p.evaluate(feature, String.class)).map(v -> v != null ? ResponseUtils.urlEncode((String)v, (char[])new char[0]) : null).toArray();
        String uri = String.format(template, templateParameters);
        Map<String, String> kvp = this.lenientQueryStringParse(uri);
        String path = ResponseUtils.getPath((String)uri);
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return path;
        }
        String baseURL = ResponseUtils.baseURL((HttpServletRequest)request.getHttpRequest());
        return ResponseUtils.buildURL((String)baseURL, (String)path, kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    private Map<String, String> lenientQueryStringParse(String path) {
        LinkedHashMap<String, String> kvp = new LinkedHashMap<String, String>();
        KvpUtils.parseQueryString((String)path).forEach((k, v) -> {
            if (v instanceof String) {
                kvp.put((String)k, (String)v);
            } else if (v instanceof String[]) {
                kvp.put((String)k, ((String[])v)[0]);
            } else if (v != null) {
                kvp.put((String)k, v.toString());
            }
        });
        return kvp;
    }
}

