/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.expressions.aggregate;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.geoserver.featurestemplating.expressions.aggregate.AggregationOp;
import org.geoserver.featurestemplating.expressions.aggregate.FilteringFunction;
import org.geoserver.featurestemplating.expressions.aggregate.SortFunction;
import org.geotools.api.filter.capability.FunctionName;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.VolatileFunction;
import org.geotools.filter.FunctionExpressionImpl;

public class StreamFunction
extends FunctionExpressionImpl
implements VolatileFunction {
    public static FunctionName NAME = StreamFunction.functionName((String)"stream", (String)"result:Object:1,1", (String[])new String[]{"v:Object:1,"});

    public StreamFunction() {
        super(NAME);
    }

    public Object evaluate(Object object) {
        List<Object> input = AggregationOp.toListObj(object);
        List<Object> result = new LinkedList<Object>(input);
        for (Expression exp : this.getParameters()) {
            if (exp instanceof SortFunction || exp instanceof FilteringFunction) {
                result = AggregationOp.toListObj(exp.evaluate(result));
                continue;
            }
            result = this.evaluateIterating(result, exp);
        }
        return result;
    }

    private LinkedList<Object> evaluateIterating(List<Object> values, Expression expression) {
        LinkedList<Object> tmpResult = new LinkedList<Object>();
        for (Object o : values) {
            Object res = expression.evaluate(o);
            if (res instanceof Collection) {
                tmpResult.addAll((List)res);
                continue;
            }
            tmpResult.add(res);
        }
        return tmpResult;
    }
}

