/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.readers;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.geoserver.featurestemplating.readers.JSONMerger;
import org.geoserver.featurestemplating.readers.RecursiveTemplateResourceParser;
import org.geoserver.platform.resource.Resource;

public class RecursiveJSONParser
extends RecursiveTemplateResourceParser {
    private static final String INCLUDE_KEY = "$include";
    private static final String MERGE_KEY = "$merge";
    public static final String INCLUDE_FLAT_KEY = "$includeFlat";
    public static final String INCLUDE_FLAT_EXPR = "$includeExpression";
    public static final String INCLUDING_NODE = "$includingNode";
    private final ObjectMapper mapper;
    private final String rootCollectionName;

    public RecursiveJSONParser(Resource resource) {
        super(resource);
        this.mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        this.rootCollectionName = "features";
    }

    public RecursiveJSONParser(Resource resource, String rootCollectionName) {
        super(resource);
        this.mapper = new ObjectMapper(new JsonFactory().enable(JsonParser.Feature.ALLOW_COMMENTS));
        this.rootCollectionName = rootCollectionName;
    }

    private RecursiveJSONParser(RecursiveJSONParser parent, Resource resource) {
        super(resource, parent);
        this.mapper = parent.mapper;
        this.rootCollectionName = parent.rootCollectionName;
    }

    public JsonNode parse() throws IOException {
        JsonNode root = this.readResource();
        JsonNode result = this.expandIncludes(root);
        result = this.processDynamicIncludeFlat(result);
        return result;
    }

    private JsonNode processDynamicIncludeFlat(JsonNode result) {
        if (this.parent == null) {
            LinkedList<JsonNode> parents = new LinkedList<JsonNode>(result.findParents(INCLUDE_FLAT_KEY));
            LinkedList<JsonNode> replacements = new LinkedList<JsonNode>();
            if (parents != null && !parents.isEmpty()) {
                parents.forEach(p -> replacements.add((JsonNode)this.buildContainer((ObjectNode)p)));
                int matched = -1;
                for (int i = 0; i < parents.size(); ++i) {
                    if (!((JsonNode)parents.get(i)).equals((Object)result)) continue;
                    matched = i;
                    break;
                }
                if (matched != -1) {
                    result = (JsonNode)replacements.get(matched);
                    parents.remove(matched);
                    replacements.remove(matched);
                }
                this.findAndReplace(result, parents, replacements);
            }
        }
        return result;
    }

    private void findAndReplace(JsonNode result, List<JsonNode> replaced, List<JsonNode> replacements) {
        if (result.isObject()) {
            ObjectNode objectNode = (ObjectNode)result;
            this.findAndReplaceInObj(objectNode, replaced, replacements);
        } else if (result.isArray()) {
            ArrayNode arrayNode = (ArrayNode)result;
            this.findAndReplaceInArray(arrayNode, replaced, replacements);
        }
    }

    private void findAndReplaceInObj(ObjectNode currNode, List<JsonNode> replaced, List<JsonNode> replacements) {
        Iterator names = currNode.fieldNames();
        while (names.hasNext()) {
            String name = (String)names.next();
            JsonNode node = currNode.get(name);
            int index = replaced.indexOf(node);
            if (index != -1) {
                currNode.set(name, replacements.get(index));
                replaced.remove(index);
                replacements.remove(index);
                continue;
            }
            this.findAndReplace(node, replaced, replacements);
        }
    }

    private void findAndReplaceInArray(ArrayNode currNode, List<JsonNode> replaced, List<JsonNode> replacements) {
        for (int i = 0; i < currNode.size(); ++i) {
            JsonNode node = currNode.get(i);
            int index = replaced.indexOf(node);
            if (index != -1) {
                currNode.set(i, replacements.get(index));
                replaced.remove(index);
                replacements.remove(index);
                continue;
            }
            this.findAndReplace(node, replaced, replacements);
        }
    }

    private ObjectNode processMergeDirective(ObjectNode root) throws IOException {
        JsonNode mergeValue = root.remove(MERGE_KEY);
        if (mergeValue.getNodeType() != JsonNodeType.STRING) {
            throw new IllegalArgumentException("$merge property must have a string value, pointing to a base template");
        }
        Resource mergeResource = this.getResource(this.resource, mergeValue.textValue());
        if (mergeResource.getType() != Resource.Type.RESOURCE) {
            throw new IllegalArgumentException("$merge resource " + mergeResource.path() + " could not be found");
        }
        RecursiveJSONParser delegate = new RecursiveJSONParser(this, mergeResource);
        JsonNode base = delegate.parse();
        JSONMerger jsonMerger = new JSONMerger(this.rootCollectionName);
        return jsonMerger.mergeTrees(base, (JsonNode)root);
    }

    private JsonNode expandIncludes(JsonNode node) throws IOException {
        if (node.isArray()) {
            return this.expandIncludesInArray((ArrayNode)node);
        }
        if (node.isObject()) {
            return this.expandIncludesInObject((ObjectNode)node);
        }
        return node;
    }

    private ObjectNode expandIncludesInObject(ObjectNode input) throws IOException {
        ObjectNode result = this.mapper.getNodeFactory().objectNode();
        Iterator names = input.fieldNames();
        while (names.hasNext()) {
            String txt;
            JsonNode processed;
            String name = (String)names.next();
            JsonNode node = input.get(name);
            if (name.equals(INCLUDE_KEY)) {
                throw new IllegalArgumentException("Cannot have an include directive as the key in an object, only $includeFlat can be used here");
            }
            if (name.equals(INCLUDE_FLAT_KEY)) {
                if (!node.isTextual()) {
                    throw new IllegalArgumentException("The value of a $includeFlat key must be the path of the file being included");
                }
                if (!this.isDynamicIncludeFlat(node)) {
                    Resource resource = this.getResource(this.resource, node.asText());
                    processed = new RecursiveJSONParser(this, resource).parse();
                    Iterator fields = processed.fieldNames();
                    while (fields.hasNext()) {
                        String field = (String)fields.next();
                        result.set(field, processed.get(field));
                    }
                    continue;
                }
            }
            if (node.isTextual() && (processed = this.processInlineDirective(txt = node.asText(), INCLUDE_KEY)) != null) {
                result.set(name, processed);
                continue;
            }
            result.set(name, this.expandIncludes(node));
        }
        if (result.has(MERGE_KEY)) {
            result = this.processMergeDirective(result);
        }
        return result;
    }

    private ObjectNode buildContainer(ObjectNode result) {
        JsonNode dynamicIncludeFlat = result.remove(INCLUDE_FLAT_KEY);
        ObjectNode objectNode = this.mapper.getNodeFactory().objectNode();
        objectNode.set(INCLUDING_NODE, (JsonNode)result);
        objectNode.set(INCLUDE_FLAT_EXPR, dynamicIncludeFlat);
        ObjectNode container = this.mapper.getNodeFactory().objectNode();
        container.set(INCLUDE_FLAT_KEY, (JsonNode)objectNode);
        return container;
    }

    private ArrayNode expandIncludesInArray(ArrayNode array) throws IOException {
        ArrayNode result = this.mapper.getNodeFactory().arrayNode();
        for (int i = 0; i < array.size(); ++i) {
            JsonNode node = array.get(i);
            if (node.isTextual()) {
                String txt = node.asText();
                JsonNode processed = this.processInlineDirective(txt, INCLUDE_KEY);
                if (processed != null) {
                    result.add(processed);
                    continue;
                }
                processed = this.processInlineDirective(node, INCLUDE_FLAT_KEY);
                if (processed != null) {
                    if (processed.isArray()) {
                        for (JsonNode child : processed) {
                            result.add(child);
                        }
                        continue;
                    }
                    if (processed.isValueNode()) {
                        result.add(processed);
                        continue;
                    }
                    throw new IllegalArgumentException("This include flat is in an array, the included object can only be another array or a value, but it's not: " + txt);
                }
            }
            result.add(this.expandIncludes(node));
        }
        return result;
    }

    private JsonNode processInlineDirective(JsonNode value, String directive) throws IOException {
        if (this.isDynamicIncludeFlat(value)) {
            return value;
        }
        return this.processInlineDirective(value.textValue(), directive);
    }

    private JsonNode processInlineDirective(String value, String directive) throws IOException {
        if (value.startsWith(directive + "{") && value.endsWith("}")) {
            String path = value.substring(directive.length() + 1, value.length() - 1);
            Resource resource = this.getResource(this.resource, path);
            return new RecursiveJSONParser(this, resource).parse();
        }
        return null;
    }

    private JsonNode readResource() throws IOException {
        try (InputStream is = this.resource.in();){
            JsonNode jsonNode = this.mapper.readTree(is);
            return jsonNode;
        }
    }

    private boolean isDynamicIncludeFlat(JsonNode node) {
        String text = node.asText();
        return text.contains(INCLUDE_FLAT_KEY.concat("{$")) || text.startsWith("${");
    }
}

