/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.utils;

import org.geotools.api.filter.expression.Expression;
import org.geotools.filter.text.cql2.CQLException;
import org.geotools.filter.text.ecql.ECQL;

public final class StaticTemplateResolver {
    private StaticTemplateResolver() {
    }

    public static String resolveTemplate(String templateContent) {
        if (templateContent == null) {
            throw new IllegalArgumentException("Template content cannot be null.");
        }
        StringBuilder resolvedContent = new StringBuilder();
        int startIndex = 0;
        while (startIndex < templateContent.length()) {
            int expressionStart = templateContent.indexOf("$${", startIndex);
            if (expressionStart == -1) {
                resolvedContent.append(templateContent.substring(startIndex));
                break;
            }
            resolvedContent.append(templateContent.substring(startIndex, expressionStart));
            startIndex = StaticTemplateResolver.processExpression(templateContent, resolvedContent, expressionStart);
        }
        return resolvedContent.toString();
    }

    private static int processExpression(String templateContent, StringBuilder resolvedContent, int expressionStart) {
        int expressionEnd = templateContent.indexOf("}", expressionStart);
        if (expressionEnd == -1) {
            throw new IllegalArgumentException("Unclosed $${} expression in template.");
        }
        String expression = templateContent.substring(expressionStart + 3, expressionEnd);
        Expression ecqlExpression = null;
        try {
            ecqlExpression = ECQL.toExpression((String)expression);
        }
        catch (CQLException e) {
            throw new RuntimeException(e);
        }
        String evaluatedValue = (String)ecqlExpression.evaluate(null, String.class);
        resolvedContent.append(evaluatedValue);
        return expressionEnd + 1;
    }
}

