/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.validation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.SourceBuilder;
import org.geoserver.featurestemplating.builders.TemplateBuilder;
import org.geoserver.featurestemplating.builders.impl.DynamicValueBuilder;
import org.geoserver.featurestemplating.builders.impl.RootBuilder;
import org.geoserver.featurestemplating.builders.impl.TemplateBuilderContext;
import org.geoserver.featurestemplating.expressions.XpathFunction;
import org.geoserver.featurestemplating.validation.ValidateExpressionVisitor;
import org.geotools.api.feature.type.FeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.api.filter.expression.Expression;
import org.geotools.api.filter.expression.ExpressionVisitor;
import org.geotools.api.filter.expression.PropertyName;
import org.geotools.filter.AttributeExpressionImpl;
import org.geotools.filter.text.cql2.CQL;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.util.logging.Logging;

public abstract class AbstractTemplateValidator {
    private static final Logger LOGGER = Logging.getLogger(AbstractTemplateValidator.class);
    private String failingAttribute;
    private List<String> sourcesFound = new ArrayList<String>();

    public boolean validateTemplate(RootBuilder root) {
        try {
            String source = null;
            ValidateExpressionVisitor validateVisitor = new ValidateExpressionVisitor(new TemplateBuilderContext(this.getFeatureType()));
            return this.validateExpressions(root, validateVisitor, source);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract FeatureType getFeatureType() throws IOException;

    public String getTypeName() throws IOException {
        return this.getFeatureType().getName().getLocalPart();
    }

    private boolean validateExpressions(TemplateBuilder builder, ValidateExpressionVisitor visitor, String source) throws IOException {
        for (TemplateBuilder jb : builder.getChildren()) {
            Filter filter;
            String siblingSource = null;
            if (jb instanceof DynamicValueBuilder) {
                DynamicValueBuilder djb = (DynamicValueBuilder)jb;
                Expression toValidate = this.getExpressionToValidate(djb, source, djb.getContextPos());
                if (!this.validate(toValidate, visitor)) {
                    if (djb.getCql() != null) {
                        this.failingAttribute = "Key: " + djb.getKey() + " Value: " + CQL.toCQL((Expression)djb.getCql());
                        return false;
                    }
                    if (djb.getXpath() != null) {
                        this.failingAttribute = "Key: " + djb.getKey() + " Value: " + CQL.toCQL((Expression)djb.getXpath());
                        return false;
                    }
                }
            } else if (jb instanceof SourceBuilder) {
                SourceBuilder sb = (SourceBuilder)jb;
                if (sb.getSource() != null && sb.getStrSource() != null) {
                    boolean topLevelFeature = sb.isTopLevelFeature();
                    boolean isValid = true;
                    if (!topLevelFeature) {
                        AttributeExpressionImpl pn = this.getSourceToValidate(sb, source);
                        isValid = this.validate(pn, visitor);
                        siblingSource = pn.getPropertyName();
                    } else if (LOGGER.isLoggable(Level.WARNING)) {
                        this.validateTopLevelSource(sb);
                    }
                    this.sourcesFound.add(sb.getStrSource());
                    if (!isValid) {
                        this.failingAttribute = "Source: " + sb.getStrSource();
                        return false;
                    }
                }
                if (!this.validateExpressions(jb, visitor, siblingSource != null ? siblingSource : source)) {
                    return false;
                }
            }
            if (!(jb instanceof AbstractTemplateBuilder) || (filter = this.getFilterToValidate((AbstractTemplateBuilder)jb, siblingSource != null ? siblingSource : source)) == null || this.validate(filter, visitor)) continue;
            this.failingAttribute = "Filter: " + CQL.toCQL((Filter)filter);
            return false;
        }
        return true;
    }

    public String getFailingAttribute() {
        return this.failingAttribute;
    }

    public boolean validate(Object toValidate, ValidateExpressionVisitor visitor) {
        if (toValidate instanceof Expression) {
            ((Expression)toValidate).accept((ExpressionVisitor)visitor, null);
        } else {
            ((Filter)toValidate).accept((FilterVisitor)visitor, null);
        }
        return visitor.isValid();
    }

    private void validateTopLevelSource(SourceBuilder builder) {
        try {
            boolean result;
            String strSource = builder.getStrSource();
            Name name = this.getFeatureType().getName();
            if (strSource.indexOf(":") != -1) {
                String[] nameAr = strSource.split(":");
                if (builder.getNamespaces() != null) {
                    String prefix = nameAr[0];
                    String uri = builder.getNamespaces().getURI(prefix);
                    result = name.getNamespaceURI().equals(uri) && this.localPartMatches(name.getLocalPart(), nameAr[1]);
                } else {
                    result = this.localPartMatches(name.getLocalPart(), nameAr[1]);
                }
            } else {
                result = name.getLocalPart().equals(strSource);
            }
            if (!result) {
                LOGGER.warning("Failed to validate the topLevel Feature source against the FeatureType. The source is " + strSource + " and the FeatureType name is " + name.toString() + ". The top level source might be still valid anyway");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean localPartMatches(String typeName, String sourceName) {
        boolean matchName = typeName.equals(sourceName);
        if (!matchName) {
            String withType = sourceName + "Type";
            matchName = typeName.equalsIgnoreCase(withType);
        }
        if (!matchName) {
            sourceName = sourceName.replaceAll("Feature", "");
            matchName = typeName.equalsIgnoreCase(sourceName);
        }
        return matchName;
    }

    private AttributeExpressionImpl getSourceToValidate(SourceBuilder sb, String strSource) {
        AttributeExpressionImpl source = (AttributeExpressionImpl)sb.getSource();
        String sourcePart = sb.getStrSource();
        strSource = strSource == null ? sourcePart : (String)strSource + "/" + sourcePart;
        return new AttributeExpressionImpl((String)strSource, source.getNamespaceContext());
    }

    private Filter getFilterToValidate(AbstractTemplateBuilder ab, String source) {
        if (ab.getFilter() != null) {
            return (Filter)this.completeXpathWithVisitor(ab.getFilter(), source, ab.getFilterContextPos());
        }
        return null;
    }

    private Expression getExpressionToValidate(DynamicValueBuilder db, String source, int contextPos) {
        if (db.getXpath() != null) {
            return this.completeXpathForValidation((PropertyName)db.getXpath(), source, contextPos);
        }
        return (Expression)this.completeXpathWithVisitor(db.getCql(), source, contextPos);
    }

    private PropertyName completeXpathForValidation(PropertyName pn, String source, int contextPos) {
        String strXpath = pn.getPropertyName();
        int i = 0;
        String newSource = source;
        if (newSource != null) {
            int lastSource = this.sourcesFound.size() - 1;
            if (contextPos == this.sourcesFound.size()) {
                --contextPos;
            }
            while (i < contextPos) {
                String toReplace = this.sourcesFound.get(lastSource - i);
                strXpath = strXpath.replaceFirst("\\.\\./", "");
                newSource = newSource.lastIndexOf(47) != -1 ? source.replace("/" + toReplace, "") : "";
                ++i;
            }
            Object newXpath = !newSource.equals("") && !strXpath.startsWith(newSource) ? newSource + "/" + pn.getPropertyName() : pn.getPropertyName();
            if (pn instanceof AttributeExpressionImpl) {
                pn = new AttributeExpressionImpl((String)newXpath, pn.getNamespaceContext());
            } else if (pn instanceof XpathFunction) {
                ((XpathFunction)pn).setPropertyName((String)newXpath);
            }
        }
        return pn;
    }

    private Object completeXpathWithVisitor(Object cql, final String source, final int contextPos) {
        DuplicatingFilterVisitor visitor = new DuplicatingFilterVisitor(){

            public Object visit(PropertyName filter, Object extraData) {
                PropertyName result = AbstractTemplateValidator.this.completeXpathForValidation(filter = (PropertyName)super.visit(filter, extraData), source, contextPos);
                if (result != null) {
                    return result;
                }
                return filter;
            }
        };
        if (cql instanceof Expression) {
            return ((Expression)cql).accept((ExpressionVisitor)visitor, null);
        }
        return ((Filter)cql).accept((FilterVisitor)visitor, null);
    }
}

