/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.geoserver.featurestemplating.writers.GMLDialectManager;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;

class GML31DialectManager
extends GMLDialectManager {
    GML31DialectManager(XMLStreamWriter streamWriter) {
        super(streamWriter, "posList");
    }

    @Override
    void writeNumberReturned(String numberReturned) throws XMLStreamException {
        this.streamWriter.writeAttribute("numberOfFeature", numberReturned);
    }

    @Override
    void writeNumberMatched(String numberMatched) throws XMLStreamException {
    }

    @Override
    void writeBoundingBox(ReferencedEnvelope envelope, CoordinateReferenceSystem crs) throws IOException {
        super.writeBoundingBox(envelope, crs, false);
    }

    @Override
    String getWfsNsUri() {
        return "http://www.opengis.net/wfs";
    }

    @Override
    String getGmlNsUri() {
        return "http://www.opengis.net/gml";
    }

    @Override
    void startFeatureMember() throws XMLStreamException {
        this.streamWriter.writeStartElement("gml", "featureMember", this.getGmlNsUri());
    }

    @Override
    void writeGeometryAttributes(int geomIndex) throws XMLStreamException {
        if (this.crs != null) {
            super.writeGeometryAttributes(geomIndex);
            this.streamWriter.writeAttribute("srsDimension", String.valueOf(this.crs.getCoordinateSystem().getDimension()));
        }
    }
}

