/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.MultiSurface;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

abstract class GMLDialectManager {
    protected XMLStreamWriter streamWriter;
    private CRS.AxisOrder axisOrder = CRS.AxisOrder.EAST_NORTH;
    protected CoordinateReferenceSystem crs;
    private String coordElementName;
    protected String typeName;
    protected Map<String, String> namespaces = new HashMap<String, String>();
    static final String GML_PREFIX = "gml";
    static final String WFS_PREFIX = "wfs";
    long currentFeatureNumber = 1L;

    GMLDialectManager(XMLStreamWriter streamWriter, String coorElementName) {
        this.streamWriter = streamWriter;
        this.coordElementName = coorElementName;
        this.namespaces.put(GML_PREFIX, this.getGmlNsUri());
        this.namespaces.put(WFS_PREFIX, this.getWfsNsUri());
    }

    void writeGeometry(Geometry geometry) throws XMLStreamException {
        String gmlNsUri = this.namespaces.get(GML_PREFIX);
        if (geometry instanceof Point) {
            this.writePoint((Point)geometry, gmlNsUri);
        } else if (geometry instanceof MultiPoint) {
            this.writeMultiPoint((MultiPoint)geometry, gmlNsUri);
        } else if (geometry instanceof LineString) {
            this.writeLineString((LineString)geometry, gmlNsUri);
        } else if (geometry instanceof MultiLineString) {
            this.writeMultiLineString((MultiLineString)geometry, gmlNsUri);
        } else if (geometry instanceof Polygon) {
            this.writePolygon((Polygon)geometry, gmlNsUri);
        } else if (geometry instanceof MultiPolygon) {
            this.writeMultiPolygon((MultiPolygon)geometry, gmlNsUri);
        }
    }

    void writePoint(Point point, String gmlNsUri) throws XMLStreamException {
        this.writePoint(point, gmlNsUri, 0);
    }

    void writePoint(Point point, String gmlNsUri, int index) throws XMLStreamException {
        this.streamWriter.writeStartElement(GML_PREFIX, "Point", gmlNsUri);
        this.writeGeometryAttributes(index);
        this.streamWriter.writeStartElement(GML_PREFIX, this.coordElementName.equals("coordinates") ? this.coordElementName : "pos", gmlNsUri);
        double y = point.getY();
        double x = point.getX();
        if (this.axisOrder == CRS.AxisOrder.NORTH_EAST) {
            this.streamWriter.writeCharacters(y + " " + x);
        } else {
            this.streamWriter.writeCharacters(x + " " + y);
        }
        this.streamWriter.writeEndElement();
        this.streamWriter.writeEndElement();
    }

    void writeMultiPoint(MultiPoint multiPoint, String gmlNsUri) throws XMLStreamException {
        int nPoints = multiPoint.getNumPoints();
        this.streamWriter.writeStartElement(GML_PREFIX, "MultiPoint", gmlNsUri);
        for (int i = 0; i < nPoints; ++i) {
            this.streamWriter.writeStartElement(GML_PREFIX, "pointMember", gmlNsUri);
            this.writeGeometryAttributes(0);
            this.writePoint((Point)multiPoint.getGeometryN(i), gmlNsUri, i);
            this.streamWriter.writeEndElement();
        }
        this.streamWriter.writeEndElement();
    }

    void writePolygon(Polygon polygon, String gmlNsUri) throws XMLStreamException {
        this.writePolygon(polygon, gmlNsUri, 0);
    }

    void writePolygon(Polygon polygon, String gmlNsUri, int index) throws XMLStreamException {
        LinearRing exteriorRing = polygon.getExteriorRing();
        Coordinate[] coordinates = exteriorRing.getCoordinates();
        this.streamWriter.writeStartElement(GML_PREFIX, "Surface", gmlNsUri);
        this.writeGeometryAttributes(index);
        this.streamWriter.writeStartElement(GML_PREFIX, "patches", gmlNsUri);
        this.streamWriter.writeStartElement(GML_PREFIX, "PolygonPatch", gmlNsUri);
        this.writePolygonRing("exterior", coordinates, gmlNsUri);
        int numInterior = polygon.getNumInteriorRing();
        for (int i = 0; i < numInterior; ++i) {
            coordinates = polygon.getInteriorRingN(i).getCoordinates();
            this.writePolygonRing("interior", coordinates, gmlNsUri);
        }
        this.streamWriter.writeEndElement();
        this.streamWriter.writeEndElement();
        this.streamWriter.writeEndElement();
    }

    void writePolygonRing(String ringName, Coordinate[] coordinates, String gmlNsUri) throws XMLStreamException {
        this.streamWriter.writeStartElement(GML_PREFIX, ringName, gmlNsUri);
        this.streamWriter.writeStartElement(GML_PREFIX, "LinearRing", gmlNsUri);
        this.streamWriter.writeStartElement(GML_PREFIX, this.coordElementName, gmlNsUri);
        this.writeCoordinates(coordinates);
        this.streamWriter.writeEndElement();
        this.streamWriter.writeEndElement();
        this.streamWriter.writeEndElement();
    }

    void writeLineString(LineString lineString, String gmlNsUri) throws XMLStreamException {
        this.writeLineString(lineString, gmlNsUri, 0);
    }

    void writeLineString(LineString lineString, String gmlNsUri, int index) throws XMLStreamException {
        Coordinate[] coordinates = lineString.getCoordinates();
        this.streamWriter.writeStartElement(GML_PREFIX, "LineString", gmlNsUri);
        this.writeGeometryAttributes(index);
        this.streamWriter.writeStartElement(GML_PREFIX, this.coordElementName, gmlNsUri);
        this.writeCoordinates(coordinates);
        this.streamWriter.writeEndElement();
        this.streamWriter.writeEndElement();
    }

    void writeMultiLineString(MultiLineString lineString, String gmlNsUri) throws XMLStreamException {
        int numGeom = lineString.getNumGeometries();
        this.streamWriter.writeStartElement(GML_PREFIX, "MultiLineString", gmlNsUri);
        this.writeGeometryAttributes(0);
        for (int i = 0; i < numGeom; ++i) {
            this.streamWriter.writeStartElement(GML_PREFIX, "LineStringMember", gmlNsUri);
            this.writeLineString((LineString)lineString.getGeometryN(i), gmlNsUri);
            this.streamWriter.writeEndElement();
        }
        this.streamWriter.writeEndElement();
    }

    void writeMultiPolygon(MultiPolygon multiPolygon, String gmlNsUri) throws XMLStreamException {
        int numGeom = multiPolygon.getNumGeometries();
        boolean isMultiSurface = multiPolygon instanceof MultiSurface;
        this.streamWriter.writeStartElement(GML_PREFIX, isMultiSurface ? "MultiSurface" : "MultiPolygon", gmlNsUri);
        this.writeGeometryAttributes(0);
        for (int i = 0; i < numGeom; ++i) {
            this.streamWriter.writeStartElement(GML_PREFIX, isMultiSurface ? "surfaceMember" : "polygonMember", gmlNsUri);
            this.writePolygon((Polygon)multiPolygon.getGeometryN(i), gmlNsUri);
            this.streamWriter.writeEndElement();
        }
        this.streamWriter.writeEndElement();
    }

    private void writeCoordinates(Coordinate[] coordinates) throws XMLStreamException {
        for (int i = 0; i < coordinates.length; ++i) {
            Coordinate coor = coordinates[i];
            double y = coor.getX();
            double x = coor.getY();
            String textString = this.axisOrder == CRS.AxisOrder.NORTH_EAST ? y + " " + x : x + " " + y;
            if (i != coordinates.length - 1) {
                textString = textString + " ";
            }
            this.streamWriter.writeCharacters(textString);
        }
    }

    abstract void writeNumberReturned(String var1) throws XMLStreamException;

    abstract void writeNumberMatched(String var1) throws XMLStreamException;

    void writeBoundingBox(ReferencedEnvelope envelope, CoordinateReferenceSystem crs, boolean useWFSPrefix) throws IOException {
        try {
            this.streamWriter.writeStartElement(useWFSPrefix ? WFS_PREFIX : GML_PREFIX, "boundedBy", this.namespaces.get(GML_PREFIX));
            this.streamWriter.writeStartElement(GML_PREFIX, "Envelope", this.namespaces.get(GML_PREFIX));
            this.writeCrs(crs);
            this.streamWriter.writeStartElement(GML_PREFIX, "lowerCorner", this.namespaces.get(GML_PREFIX));
            this.streamWriter.writeCharacters(envelope.getMinY() + " " + envelope.getMinX());
            this.streamWriter.writeEndElement();
            this.streamWriter.writeStartElement(GML_PREFIX, "upperCorner", this.namespaces.get(GML_PREFIX));
            this.streamWriter.writeCharacters(envelope.getMaxX() + " " + envelope.getMaxX());
            this.streamWriter.writeEndElement();
            this.streamWriter.writeEndElement();
            this.streamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    abstract void writeBoundingBox(ReferencedEnvelope var1, CoordinateReferenceSystem var2) throws IOException;

    void writeCrs(CoordinateReferenceSystem crs) throws XMLStreamException, IOException {
        if (crs != null) {
            this.streamWriter.writeAttribute("srsDimension", String.valueOf(crs.getCoordinateSystem().getDimension()));
            String crsIdentifier = TemplateOutputWriter.getCRSIdentifier(crs);
            this.streamWriter.writeAttribute("srsName", crsIdentifier);
        }
    }

    void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
    }

    void setAxisOrder(CRS.AxisOrder axisOrder) {
        this.axisOrder = axisOrder;
    }

    abstract String getWfsNsUri();

    abstract String getGmlNsUri();

    Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    abstract void startFeatureMember() throws XMLStreamException;

    void endFeatureMember() throws XMLStreamException {
        this.streamWriter.writeEndElement();
        ++this.currentFeatureNumber;
    }

    void writeGeometryAttributes(int geometryIndex) throws XMLStreamException {
        if (this.crs != null) {
            this.streamWriter.writeAttribute("srsName", CRS.toSRS((CoordinateReferenceSystem)this.crs));
        }
    }

    void setTypeName(String typeName) {
        this.typeName = typeName;
        this.currentFeatureNumber = 1L;
    }
}

