/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.referencing.CRS;
import org.geotools.util.Converters;

public abstract class TemplateOutputWriter
implements AutoCloseable {
    protected long numberReturned = 0L;
    protected CoordinateReferenceSystem crs;
    protected CRS.AxisOrder axisOrder = CRS.AxisOrder.EAST_NORTH;

    public abstract void writeElementName(Object var1, EncodingHints var2) throws IOException;

    public abstract void writeElementValue(Object var1, EncodingHints var2) throws IOException;

    public abstract void writeElementNameAndValue(String var1, Object var2, EncodingHints var3) throws IOException;

    public abstract void writeStaticContent(String var1, Object var2, EncodingHints var3) throws IOException;

    public abstract void startObject(String var1, EncodingHints var2) throws IOException;

    public abstract void endObject(String var1, EncodingHints var2) throws IOException;

    public abstract void startArray(String var1, EncodingHints var2) throws IOException;

    public abstract void endArray(String var1, EncodingHints var2) throws IOException;

    public abstract void startTemplateOutput(EncodingHints var1) throws IOException;

    public abstract void endTemplateOutput(EncodingHints var1) throws IOException;

    public abstract void writeCollectionCounts(BigInteger var1) throws IOException;

    public abstract void writeCrs() throws IOException;

    public abstract void writeCollectionBounds(ReferencedEnvelope var1) throws IOException;

    public abstract void writeTimeStamp() throws IOException;

    public abstract void writeNumberReturned() throws IOException;

    public void incrementNumberReturned() {
        ++this.numberReturned;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.crs;
    }

    public void setCrs(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.setAxisOrder(CRS.getAxisOrder((CoordinateReferenceSystem)crs));
    }

    public void setAxisOrder(CRS.AxisOrder axisOrder) {
        this.axisOrder = axisOrder;
    }

    protected static String getCRSIdentifier(CoordinateReferenceSystem crs) throws IOException {
        try {
            Object identifier = null;
            Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            if (code != null) {
                if (code != null) {
                    identifier = SrsSyntax.OGC_URN.getPrefix() + code;
                }
            } else {
                identifier = ResourcePool.lookupIdentifier((CoordinateReferenceSystem)crs, (boolean)true);
            }
            return identifier;
        }
        catch (FactoryException e) {
            throw new IOException(e);
        }
    }

    protected boolean isNull(Object value) {
        boolean isNull = false;
        if (value == null || value.equals("null") || "".equals(value)) {
            isNull = true;
        } else if (value instanceof List) {
            isNull = ((List)value).isEmpty();
        } else if (value.getClass().isArray()) {
            List list = (List)Converters.convert((Object)value, List.class);
            isNull = list.isEmpty();
        }
        return isNull;
    }

    protected <T> T getEncodingHintIfPresent(EncodingHints encodingHints, String name, Class<T> cast) {
        T result = null;
        if (encodingHints != null) {
            result = encodingHints.get(name, cast);
        }
        return result;
    }
}

