/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.writers;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringEscapeUtils;
import org.geoserver.featurestemplating.builders.AbstractTemplateBuilder;
import org.geoserver.featurestemplating.builders.EncodingHints;
import org.geoserver.featurestemplating.writers.TemplateOutputWriter;
import org.geoserver.util.ISO8601Formatter;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.locationtech.jts.geom.Geometry;

public abstract class XMLTemplateWriter
extends TemplateOutputWriter {
    protected XMLStreamWriter streamWriter;
    protected Map<String, String> namespaces = new HashMap<String, String>();
    protected String schemaLocations;

    public XMLTemplateWriter(XMLStreamWriter streamWriter) {
        this.streamWriter = streamWriter;
    }

    @Override
    public void writeElementName(Object elementName, EncodingHints encodingHints) throws IOException {
        try {
            String elemName = elementName.toString();
            String[] elems = elemName.split(":");
            if (elems.length > 1) {
                this.streamWriter.writeStartElement(elems[0], elems[1], this.namespaces.get(elems[0]));
            } else {
                this.streamWriter.writeStartElement(elems[0]);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeElementValue(Object elementValue, EncodingHints encodingHints) throws IOException {
        this.writeElementNameAndValue(null, elementValue, encodingHints);
    }

    protected abstract void writeGeometry(Geometry var1) throws XMLStreamException;

    @Override
    public void writeStaticContent(String name, Object staticContent, EncodingHints encodingHints) throws IOException {
        try {
            if (this.isEncodeAsAttribute(encodingHints)) {
                this.writeAsAttribute(name, staticContent, encodingHints);
            } else {
                this.streamWriter.writeStartElement(name);
                this.evaluateChildren(encodingHints);
                this.streamWriter.writeCharacters(StringEscapeUtils.escapeHtml((String)staticContent.toString()));
                this.streamWriter.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void startObject(String name, EncodingHints encodingHints) throws IOException {
        this.writeElementName(name, encodingHints);
    }

    @Override
    public void endObject(String name, EncodingHints encodingHints) throws IOException {
        try {
            this.streamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void startArray(String name, EncodingHints encodingHints) throws IOException {
        this.writeElementName(name, encodingHints);
    }

    @Override
    public void endArray(String name, EncodingHints encodingHints) throws IOException {
        try {
            this.streamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void close() throws IOException {
        try {
            this.streamWriter.close();
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeElementNameAndValue(String key, Object elementValue, EncodingHints encodingHints) throws IOException {
        boolean encodeAsAttribute = this.isEncodeAsAttribute(encodingHints);
        boolean repeatName = elementValue instanceof List && ((List)elementValue).size() > 1;
        boolean canClose = false;
        if (key != null && !repeatName && !encodeAsAttribute) {
            this.writeElementName(key, encodingHints);
            this.evaluateChildren(encodingHints);
        }
        try {
            if (this.isNull(elementValue)) {
                String value = "";
                if (encodeAsAttribute) {
                    this.writeAsAttribute(key, value, encodingHints);
                } else {
                    this.writeAsCharacters(value);
                    canClose = true;
                }
            } else if (elementValue instanceof String || elementValue instanceof Number || elementValue instanceof Boolean || elementValue instanceof URI || elementValue instanceof URL) {
                if (encodeAsAttribute) {
                    this.writeAsAttribute(key, elementValue, encodingHints);
                } else {
                    this.writeAsCharacters(String.valueOf(elementValue));
                    canClose = true;
                }
            } else if (elementValue instanceof Geometry) {
                this.writeGeometry((Geometry)elementValue);
                canClose = true;
            } else if (elementValue instanceof Date) {
                Date timeStamp = (Date)elementValue;
                String formatted = new ISO8601Formatter().format(timeStamp);
                if (encodeAsAttribute) {
                    this.writeAsAttribute(key, elementValue, encodingHints);
                } else {
                    this.streamWriter.writeCharacters(formatted);
                    canClose = true;
                }
            } else if (elementValue instanceof ComplexAttribute) {
                ComplexAttribute attr = (ComplexAttribute)elementValue;
                this.writeElementNameAndValue(encodeAsAttribute ? key : null, attr.getValue(), encodingHints);
            } else if (elementValue instanceof Attribute) {
                Attribute attr = (Attribute)elementValue;
                this.writeElementNameAndValue(encodeAsAttribute ? key : null, attr.getValue(), encodingHints);
            } else if (elementValue instanceof List) {
                List list = (List)elementValue;
                if (!repeatName && !list.isEmpty()) {
                    this.writeElementNameAndValue(key, list.get(0), encodingHints);
                } else {
                    for (int i = 0; i < list.size(); ++i) {
                        this.writeElementNameAndValue(key, list.get(i), encodingHints);
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
        if (canClose) {
            this.endObject(null, null);
        }
    }

    private void writeAsCharacters(String value) throws XMLStreamException {
        if (value == null) {
            value = "";
        }
        value = this.escape(value);
        this.streamWriter.writeCharacters(value);
    }

    protected String escape(String value) {
        return StringEscapeUtils.escapeXml((String)value);
    }

    private void writeAsAttribute(String key, Object elementValue, EncodingHints encodingHints) throws IOException {
        try {
            String strVal = elementValue.toString();
            if (key.indexOf(":") != -1 && !key.contains("xmlns")) {
                String[] splitKey = key.split(":");
                this.streamWriter.writeAttribute(splitKey[0], this.namespaces.get(splitKey[0]), splitKey[1], strVal);
            } else if (key.contains("xmlns")) {
                this.streamWriter.writeNamespace(key.split(":")[1], strVal);
            } else {
                this.streamWriter.writeAttribute(key, strVal);
            }
        }
        catch (XMLStreamException e) {
            throw new IOException(e);
        }
    }

    public void addNamespaces(Map<String, String> namespaces) {
        this.namespaces.putAll(namespaces);
    }

    public void addSchemaLocations(String schemaLocation) {
        this.schemaLocations = this.schemaLocations != null ? this.schemaLocations + " ".concat(schemaLocation) : schemaLocation;
    }

    private boolean isEncodeAsAttribute(EncodingHints encodingHints) {
        boolean result = false;
        Boolean encodeAsAttribute = this.getEncodingHintIfPresent(encodingHints, "ENCODE_AS_ATTRIBUTE", Boolean.class);
        if (encodeAsAttribute != null) {
            result = encodeAsAttribute;
        }
        return result;
    }

    private void evaluateChildren(EncodingHints encodingHints) throws IOException {
        AbstractTemplateBuilder.ChildrenEvaluation eval = encodingHints.get("CHILDREN_EVALUATION", AbstractTemplateBuilder.ChildrenEvaluation.class);
        if (eval != null) {
            eval.evaluate();
        }
    }
}

