/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class FlatGeoJSONComplexFeaturesResponseAPITest
extends TemplateComplexTestSupport {
    private static final String FLAT_MF_TEMPLATE = "FlatGeoJSONMappedFeature";
    private static final String FLAT_MF_RULE_CQL = "requestParam('FlatGeoJSONMappedFeature')='true'";
    private static final String FLAT_MF_PARAM = "&FlatGeoJSONMappedFeature=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "FlatGeoJSONMappedFeature.json";
        this.setUpTemplate(FLAT_MF_RULE_CQL, SupportedFormat.GEOJSON, templateMappedFeature, FLAT_MF_TEMPLATE, ".json", "gsml", mappedFeature);
    }

    @Test
    public void testGeoJSONResponseOGCAPI() throws Exception {
        String condition = FLAT_MF_RULE_CQL;
        Object path = "ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fgeo%2Bjson";
        path = (String)path + FLAT_MF_PARAM;
        JSONObject result = (JSONObject)this.getJson((String)path);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            this.checkInspireMappedFeature(feature);
        }
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONQueryOGCAPI() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fgeo%2Bjson").append("&filter-lang=cql-text").append("&filter= features.properties.gsml:GeologicUnit_gsml:composition.gsml:compositionPart.lithology.name").append(" = 'name_2' ").append(FLAT_MF_PARAM);
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)((JSONObject)features.get(0)).get("@id").toString(), (Object)"mf4");
        this.checkInspireMappedFeature(features.getJSONObject(0));
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONResponseWithCustomSeparator() throws Exception {
        Object path = "ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fgeo%2Bjson";
        path = (String)path + FLAT_MF_PARAM;
        path = (String)path + "&separator=.";
        JSONObject result = (JSONObject)this.getJson((String)path);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            JSONObject properties = feature.getJSONObject("properties");
            Set keys = properties.keySet();
            for (String key : keys) {
                boolean keyWithSep = !key.equals("@id") && !key.equals("description") && !key.equals("gsml:geologicUnitType");
                if (!keyWithSep) continue;
                String[] arKey = key.split("\\.");
                Assert.assertTrue((arKey.length > 0 ? 1 : 0) != 0);
            }
        }
    }
}

