/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;

public class JSONLDGetComplexFeaturesResponseAPITest
extends TemplateComplexTestSupport {
    protected static final String MF_JSON_LD = "MappedFeatureJSONLD";
    protected static final String MF_JSON_LD_FILTERS = "MappedFeatureJSONLDFilters";
    private static final String MF_JSON_LD_PARAM = "&MappedFeatureJSONLD=true";
    private static final String MF_JSON_LD_FILTER_PARAM = "&MappedFeatureJSONLDFilters=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "MappedFeature.json";
        this.setUpTemplate("requestParam('MappedFeatureJSONLD')='true'", SupportedFormat.JSONLD, templateMappedFeature, MF_JSON_LD, ".json", "gsml", mappedFeature);
        String mappedFeatureFilter = "MappedFeatureIteratingAndCompositeFilter.json";
        this.setUpTemplate("requestParam('MappedFeatureJSONLDFilters')='true'", SupportedFormat.JSONLD, mappedFeatureFilter, MF_JSON_LD_FILTERS, ".json", "gsml", mappedFeature);
    }

    @Test
    public void testJsonLdResponseOGCAPI() throws Exception {
        String path = "ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fld%2Bjson&MappedFeatureJSONLD=true";
        JSONObject result = (JSONObject)this.getJsonLd(path);
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            this.checkMappedFeatureJSON(feature);
        }
    }

    @Test
    public void testJsonLdQueryOGCAPI() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fld%2Bjson").append("&filter-lang=cql-text").append("&filter= features.gsml:GeologicUnit.gsml:composition.gsml:compositionPart.lithology.name.value").append(" = 'name_2' ").append(MF_JSON_LD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)((JSONObject)features.get(0)).get("@id").toString(), (Object)"mf4");
    }

    @Test
    public void testJsonLdQueryEnvSubstitutionOnAttributeName() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fld%2Bjson").append("&env=id:envId").append(MF_JSON_LD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            Assert.assertTrue((boolean)feature.has("envId"));
        }
    }

    @Test
    public void testJsonLdQueryEnvSubstitutionOnSource() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fld%2Bjson").append("&env=source:notComposition").append(MF_JSON_LD_PARAM);
        MockHttpServletResponse response = this.getAsServletResponse(sb.toString());
        Assert.assertTrue((boolean)response.getContentAsString().contains("Failed to validate template for feature type MappedFeature. Failing attribute is Source: gsml:notComposition"));
    }

    @Test
    public void testJsonLdQueryEnvSubstitutionOnAttribute() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fld%2Bjson").append("&env=positionalAccuracyType:CGI_NotNumericValue").append(MF_JSON_LD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            String typeValue = feature.getJSONObject("gsml:positionalAccuracy").getString("type");
            Assert.assertEquals((Object)"CGI_NotNumericValue", (Object)typeValue);
        }
    }

    @Test
    public void testJsonLdQueryEnvSubstitutionOnXpath() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fld%2Bjson").append("&env=previous:@id").append(MF_JSON_LD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = features.getJSONObject(i);
            if ("mf5".equals(feature.get("@id"))) continue;
            JSONObject geologicUnit = feature.getJSONObject("gsml:GeologicUnit");
            String geologicUnitId = geologicUnit.getString("@id");
            Assert.assertNotNull((Object)geologicUnitId);
            JSONArray composition = geologicUnit.getJSONArray("gsml:composition");
            Assert.assertTrue((composition.size() > 0 ? 1 : 0) != 0);
            for (int j = 0; j < composition.size(); ++j) {
                JSONObject compositionObj = composition.getJSONObject(j);
                Assert.assertEquals((Object)geologicUnitId, (Object)compositionObj.getString("previousContextValue"));
            }
        }
    }

    @Test
    public void testJsonLdQueryPointingToArray() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fld%2Bjson").append("&filter= features.gsml:positionalAccuracy.valueArray1 > 120").append(MF_JSON_LD_PARAM);
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        JSONArray features = result.getJSONArray("features");
        Assert.assertEquals((long)3L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject f = features.getJSONObject(i);
            JSONArray values = f.getJSONObject("gsml:positionalAccuracy").getJSONArray("valueArray");
            Assert.assertTrue((values.getInt(0) > 120 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testJsonLdContextValidationFails() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fld%2Bjson").append("&validation=true").append(MF_JSON_LD_PARAM);
        MockHttpServletResponse result = this.getAsServletResponse(sb.toString());
        String strResult = result.getContentAsString();
        Assert.assertTrue((boolean)strResult.contains("Validation failed. Unable to resolve the following fields against the @context: proportion,previousContextValue,lithology,valueArray,type,value,@codeSpace."));
    }

    @Test
    public void testJsonLdResponseOGCAPISingleFeature() throws Exception {
        String path = "ogc/features/v1/collections/gsml:MappedFeature/items/mf4?f=application%2Fld%2Bjson&MappedFeatureJSONLD=true";
        JSONObject result = (JSONObject)this.getJsonLd(path);
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        Assert.assertFalse((boolean)result.has("features"));
        Assert.assertEquals((Object)"mf4", (Object)result.getString("@id"));
        Assert.assertEquals((Object)"MURRADUC BASALT", (Object)result.getString("name"));
        Assert.assertTrue((boolean)result.has("@type"));
        Assert.assertTrue((boolean)result.has("gsml:positionalAccuracy"));
        Assert.assertTrue((boolean)result.has("gsml:GeologicUnit"));
        Assert.assertTrue((boolean)result.has("geometry"));
    }

    @Test
    public void testContentNegotiationByProfile() throws Exception {
        String profile = "header('Accept-Profile')='http://my-test-profile/ld+json'";
        FeatureTypeInfo mappedFeature = this.getCatalog().getFeatureTypeByName("gsml", "MappedFeature");
        this.setUpTemplate(null, profile, SupportedFormat.JSONLD, "MappedFeature.json", "ProfileJsonLDTemplate", ".json", "gsml", mappedFeature);
        String path = "ogc/features/v1/collections/gsml:MappedFeature/items?f=application%2Fld%2Bjson";
        MockHttpServletRequest request = this.createRequest(path);
        request.setMethod("GET");
        request.setContent(new byte[0]);
        request.addHeader("Accept-Profile", (Object)"http://my-test-profile/ld+json");
        MockHttpServletResponse response = this.dispatch((HttpServletRequest)request, null);
        JSONObject result = (JSONObject)this.json(response);
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            this.checkMappedFeatureJSON(feature);
        }
    }

    @Test
    public void testJsonLdOgcFilterConcatenation() throws Exception {
        String cqlFilter = "features.gsml:GeologicUnit.gsml:composition.gsml:compositionPart.gsml:role.value = ";
        JSONArray features = this.getResultFilterConcatenated(cqlFilter, "'fictitious component'", MF_JSON_LD_FILTER_PARAM);
        Assert.assertEquals((long)0L, (long)features.size());
        JSONArray features2 = this.getResultFilterConcatenated(cqlFilter, "'interbedded component'", MF_JSON_LD_FILTER_PARAM);
        Assert.assertEquals((long)1L, (long)features2.size());
    }

    private JSONArray getResultFilterConcatenated(String cql_filter, String equalsTo, String reqParam) throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application%2Fld%2Bjson").append("&filter-lang=cql-text").append("&filter= ").append(cql_filter).append(equalsTo);
        if (reqParam != null) {
            sb.append(reqParam);
        }
        JSONObject result = (JSONObject)this.getJsonLd(sb.toString());
        Object context = result.get("@context");
        this.checkContext(context);
        Assert.assertNotNull((Object)context);
        return result.getJSONArray("features");
    }
}

