/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.junit.Assert;
import org.junit.Test;

public class GeoJSONGetComplexFeaturesResponseAPITest
extends TemplateComplexTestSupport {
    private static final String MF_TEMPLATE_GEO_JSON = "GeoJSONMappedFeature";
    private static final String MF_TEMPLATE_GEO_JSON_RULE_CQL = "requestParam('GeoJSONMappedFeature')='true'";
    private static final String MF_TEMPLATE_PARAM = "&GeoJSONMappedFeature=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "MappedFeatureGeoJSON.json";
        this.setUpTemplate(MF_TEMPLATE_GEO_JSON_RULE_CQL, SupportedFormat.GEOJSON, templateMappedFeature, MF_TEMPLATE_GEO_JSON, ".json", "gsml", mappedFeature);
    }

    @Test
    public void testGeoJSONResponseOGCAPI() throws Exception {
        String path = "ogc/features/v1/collections/gsml:MappedFeature/items?f=application/json&GeoJSONMappedFeature=true";
        JSONObject result = (JSONObject)this.getJson(path);
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)5L, (long)features.size());
        for (int i = 0; i < features.size(); ++i) {
            JSONObject feature = (JSONObject)features.get(i);
            this.checkMappedFeatureGeoJSON(feature);
        }
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONQueryOGCAPI() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items?f=application/json").append("&filter-lang=cql-text").append("&filter= features.gsml:GeologicUnit.gsml:composition.gsml:compositionPart.lithology.name.value").append(" = 'name_2' ").append(MF_TEMPLATE_PARAM);
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        JSONArray features = (JSONArray)result.get("features");
        Assert.assertEquals((long)1L, (long)features.size());
        Assert.assertEquals((Object)((JSONObject)features.get(0)).get("@id").toString(), (Object)"mf4");
        this.checkMappedFeatureGeoJSON(features.getJSONObject(0));
        this.checkAdditionalInfo(result);
    }

    @Test
    public void testGeoJSONSingleFeature() throws Exception {
        StringBuilder sb = new StringBuilder("ogc/features/v1/collections/").append("gsml:MappedFeature").append("/items/mf4?f=application%2Fgeo%2Bjson").append(MF_TEMPLATE_PARAM);
        JSONObject result = (JSONObject)this.getJson(sb.toString());
        Assert.assertFalse((boolean)result.has("features"));
        Assert.assertEquals((Object)"mf4", (Object)result.getString("@id"));
        Assert.assertEquals((Object)"FeatureName: MURRADUC BASALT", (Object)result.getString("name"));
        Assert.assertTrue((boolean)result.has("@type"));
        Assert.assertTrue((boolean)result.has("gsml:positionalAccuracy"));
        Assert.assertTrue((boolean)result.has("gsml:GeologicUnit"));
        Assert.assertTrue((boolean)result.has("geometry"));
        Assert.assertTrue((boolean)result.has("links"));
    }
}

