/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.featurestemplating.response;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.data.test.SystemTestData;
import org.geoserver.featurestemplating.configuration.SupportedFormat;
import org.geoserver.featurestemplating.response.TemplateComplexTestSupport;
import org.junit.Test;
import org.w3c.dom.Document;

public class HTMLComplexFeaturesResponseApiTest
extends TemplateComplexTestSupport {
    private static final String MF_HTML = "HTMLMappedFeatureFilter";
    private static final String MF_HTML_PARAM = "&HTMLMappedFeatureFilter=true";

    public void onSetUp(SystemTestData testData) throws IOException {
        Catalog catalog = this.getCatalog();
        FeatureTypeInfo mappedFeature = catalog.getFeatureTypeByName("gsml", "MappedFeature");
        String templateMappedFeature = "HTMLFilteredMappedFeature.xhtml";
        this.setUpTemplate("requestParam('HTMLMappedFeatureFilter')='true'", SupportedFormat.HTML, templateMappedFeature, MF_HTML, ".xhtml", "gsml", mappedFeature);
    }

    @Test
    public void getFilteredMappedFeature() throws IOException {
        Document doc = this.getAsDOM("ogc/features/v1/collections/gsml:MappedFeature/items?f=text/html&HTMLMappedFeatureFilter=true");
        this.assertXpathCount(1, "//html/head/script", doc);
        this.assertXpathCount(1, "//html/head/style", doc);
        this.assertXpathCount(1, "//html/head/link", doc);
        this.assertXpathEvaluatesTo("stylesheet", "//html/head/link/@rel", doc);
        this.assertXpathEvaluatesTo("some/css/href", "//html/head/link/@href", doc);
        this.assertXpathEvaluatesTo("text/css", "//html/head/link/@type", doc);
        this.assertXpathEvaluatesTo("all", "//html/head/link/@media", doc);
        this.assertXpathCount(5, "//html/body/ul/li[./span = 'MappedFeature']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf1']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf2']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf3']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf4']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul[./li = 'mf5']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'GUNTHORPE FORMATION']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'MERCIA MUDSTONE GROUP']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'CLIFTON FORMATION']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'MURRADUC BASALT']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul[./li = 'IDONTKNOW']", doc);
        this.assertXpathCount(5, "//html/body/ul/li/ul/li[./span = 'Shape']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li[./span = 'Specifications']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li[./span = 'Geologic Unit']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li[./span = 'Purpose']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = 'instance']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = 'New Group']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul[./li = '-Xy']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li[./span = 'Composition Parts']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul/li[./span = 'Part']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul/li/ul/li[./span = 'Role']", doc);
        this.assertXpathCount(1, "//html/body/ul/li/ul/li/ul/li/ul/li/ul/li/ul/li/ul[./li = 'interbedded component']", doc);
    }
}

